/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsd.documentation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.util.Resource;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public abstract class DocumentationOptions
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)DocumentationOptions.class.getName());
    public static final String IMAGES_DIRECTORY = "img";
    public static final String IMAGES_DIRECTORY_PDF = "images_pdf";
    private static final URL[] HTML_IMAGES = new URL[]{Resource.getResource("/builtin/documentation/img/cBL.gif"), Resource.getResource("/builtin/documentation/img/cBR.gif"), Resource.getResource("/builtin/documentation/img/cTL.gif"), Resource.getResource("/builtin/documentation/img/cTR.gif"), Resource.getResource("/builtin/documentation/img/lB.gif"), Resource.getResource("/builtin/documentation/img/lL.gif"), Resource.getResource("/builtin/documentation/img/lR.gif"), Resource.getResource("/builtin/documentation/img/lT.gif"), Resource.getResource("/builtin/documentation/img/hierarchy_arrow.gif"), Resource.getResource("/builtin/documentation/img/btM.gif"), Resource.getResource("/builtin/documentation/img/btP.gif")};
    public static final int FORMAT_HTML = 1;
    public static final int FORMAT_PDF = 2;
    public static final int FORMAT_DOCBOOK = 3;
    public static final int FORMAT_CUSTOM = 4;
    public static final int FORMAT_DITA = 5;
    private String partiallyExpandedOutputFile;
    private String unexpandedOutputFile;
    private int splitMethod = 1;
    private boolean openOutputInBrowser = true;
    protected int format = 1;
    private URL customXSL;
    private boolean deleteXMLFiles = true;
    private boolean includeIndex = true;
    private boolean copyAdditionalResources = false;
    private URL additionalResourcesDir;

    public DocumentationOptions() {
    }

    public DocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3) {
        this(string, n2, bl, n3, uRL, bl2, bl3, false, null);
    }

    public DocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3, boolean bl4, URL uRL2) {
        this.unexpandedOutputFile = string;
        this.partiallyExpandedOutputFile = EditorVariables.expandEditorVariables(this.unexpandedOutputFile, null);
        this.splitMethod = n2;
        this.openOutputInBrowser = bl;
        this.format = n3;
        this.customXSL = uRL;
        this.deleteXMLFiles = bl2;
        this.includeIndex = bl3;
        this.copyAdditionalResources = bl4;
        this.additionalResourcesDir = uRL2;
    }

    public File getOutputFile(String string) {
        if (this.partiallyExpandedOutputFile == null) {
            this.partiallyExpandedOutputFile = EditorVariables.expandEditorVariables(this.unexpandedOutputFile, null);
        }
        String string2 = EditorVariables.expandEditorVariables(this.partiallyExpandedOutputFile, string);
        return URLUtil.resolveRelativeSystemID((String)string, (String)string2);
    }

    public String getUnexpandedOutputFile() {
        return this.unexpandedOutputFile;
    }

    public int getSplitMethod() {
        if (this.format == 3 || this.format == 2) {
            return 1;
        }
        if (this.format == 5) {
            return 4;
        }
        return this.splitMethod;
    }

    public boolean isOpenOutputInBrowser() {
        return this.openOutputInBrowser;
    }

    public int getFormat() {
        return this.format;
    }

    public URL getCustomURL() {
        return this.customXSL;
    }

    public boolean isDeleteXMLFiles() {
        return this.format != 4 || this.deleteXMLFiles;
    }

    public boolean isIncludeIndex() {
        return this.includeIndex;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.unexpandedOutputFile == null) {
            throw new InvalidPersistentObjException("No output file in the documentation options");
        }
        if (this.format != 1 && this.format != 4 && this.format != 2 && this.format != 5 && this.format != 3) {
            throw new InvalidPersistentObjException("Unknown format");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"partiallyExpandedOutputFile"};
    }

    public void setOutputFile(String string) {
        this.unexpandedOutputFile = string;
        this.partiallyExpandedOutputFile = EditorVariables.expandEditorVariables(this.unexpandedOutputFile, null);
    }

    public void setSplitMethod(int n2) {
        this.splitMethod = n2;
    }

    public void setIncludeIndex(boolean bl) {
        this.includeIndex = bl;
    }

    public void setDeleteXMLFiles(boolean bl) {
        this.deleteXMLFiles = bl;
    }

    public void setOpenOutputInBrowser(boolean bl) {
        this.openOutputInBrowser = bl;
    }

    public void setFormat(int n2) {
        this.format = n2;
    }

    public void setCustomXSL(URL uRL) {
        this.customXSL = uRL;
    }

    public boolean isCopyAdditionalResources() {
        return this.copyAdditionalResources;
    }

    public void setCopyAdditionalResources(boolean bl) {
        this.copyAdditionalResources = bl;
    }

    public URL getAdditionalResourcesDir() {
        return this.additionalResourcesDir;
    }

    public void setAdditionalResourcesDir(URL uRL) {
        this.additionalResourcesDir = uRL;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public static String getCssFileName() {
        return "docHtml.css";
    }

    public static void copyAdditionalResources(File file, File file2) {
        if (file2 != null && file != null) {
            if (!(file2 = new File(file2, file.getName())).exists()) {
                file2.mkdir();
            }
            if (file.exists()) {
                try {
                    FileSystemUtil.copyDir((File)file, (File)file2, (boolean)true, (boolean)false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.error((Object)fileNotFoundException, (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                }
            }
        }
    }

    public abstract URL getXSL();

    public static void copyImages(File file, URL[] uRLArray) {
        if (!(file = new File(file, IMAGES_DIRECTORY)).exists()) {
            file.mkdir();
        }
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            File file2 = new File(file, URLUtil.extractFileName((URL)uRLArray[i2]));
            try {
                FileSystemUtil.copyInputStreamToOutputStream((InputStream)uRLArray[i2].openStream(), (OutputStream)new FileOutputStream(file2), (boolean)true);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)fileNotFoundException, (Throwable)fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
    }

    public static void copyHTMLImages(File file) {
        DocumentationOptions.copyImages(file, HTML_IMAGES);
    }

    public static void deleteHTMLImages(File file) {
        for (URL uRL : HTML_IMAGES) {
            String string = URLUtil.extractFileName((URL)uRL);
            new File(file, string).delete();
        }
    }
}

