/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.xpath;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.HomogeneityChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SafeXPathChecker {
    private static final Map<String, Boolean> SAFE_BUILTIN_FUNCTIONS = ImmutableMap.builder().put((Object)"abs", (Object)Boolean.TRUE).put((Object)"accumulator-after", (Object)Boolean.TRUE).put((Object)"accumulator-before", (Object)Boolean.TRUE).put((Object)"adjust-date-to-timezone", (Object)Boolean.TRUE).put((Object)"adjust-dateTime-to-timezone", (Object)Boolean.TRUE).put((Object)"adjust-time-to-timezone", (Object)Boolean.TRUE).put((Object)"analyze-string", (Object)Boolean.TRUE).put((Object)"apply", (Object)Boolean.FALSE).put((Object)"available-environment-variables", (Object)Boolean.FALSE).put((Object)"available-system-properties", (Object)Boolean.FALSE).put((Object)"avg", (Object)Boolean.TRUE).put((Object)"base-uri", (Object)Boolean.TRUE).put((Object)"boolean", (Object)Boolean.TRUE).put((Object)"ceiling", (Object)Boolean.TRUE).put((Object)"codepoint-equal", (Object)Boolean.TRUE).put((Object)"codepoints-to-string", (Object)Boolean.TRUE).put((Object)"collation-key", (Object)Boolean.TRUE).put((Object)"collection", (Object)Boolean.FALSE).put((Object)"compare", (Object)Boolean.TRUE).put((Object)"concat", (Object)Boolean.TRUE).put((Object)"contains", (Object)Boolean.TRUE).put((Object)"contains-token", (Object)Boolean.TRUE).put((Object)"copy-of", (Object)Boolean.TRUE).put((Object)"count", (Object)Boolean.TRUE).put((Object)"current", (Object)Boolean.TRUE).put((Object)"current-date", (Object)Boolean.TRUE).put((Object)"current-dateTime", (Object)Boolean.TRUE).put((Object)"current-group", (Object)Boolean.TRUE).put((Object)"current-grouping-key", (Object)Boolean.TRUE).put((Object)"current-merge-group", (Object)Boolean.TRUE).put((Object)"current-merge-key", (Object)Boolean.TRUE).put((Object)"current-output-uri", (Object)Boolean.TRUE).put((Object)"current-time", (Object)Boolean.TRUE).put((Object)"data", (Object)Boolean.TRUE).put((Object)"dateTime", (Object)Boolean.TRUE).put((Object)"day-from-date", (Object)Boolean.TRUE).put((Object)"day-from-dateTime", (Object)Boolean.TRUE).put((Object)"days-from-duration", (Object)Boolean.TRUE).put((Object)"deep-equal", (Object)Boolean.TRUE).put((Object)"default-collation", (Object)Boolean.TRUE).put((Object)"default-language", (Object)Boolean.TRUE).put((Object)"distinct-values", (Object)Boolean.TRUE).put((Object)"doc", (Object)Boolean.FALSE).put((Object)"doc-available", (Object)Boolean.FALSE).put((Object)"document", (Object)Boolean.FALSE).put((Object)"document-uri", (Object)Boolean.TRUE).put((Object)"element-available", (Object)Boolean.FALSE).put((Object)"element-with-id", (Object)Boolean.TRUE).put((Object)"empty", (Object)Boolean.TRUE).put((Object)"encode-for-uri", (Object)Boolean.TRUE).put((Object)"ends-with", (Object)Boolean.TRUE).put((Object)"environment-variable", (Object)Boolean.FALSE).put((Object)"error", (Object)Boolean.TRUE).put((Object)"escape-html-uri", (Object)Boolean.TRUE).put((Object)"exactly-one", (Object)Boolean.TRUE).put((Object)"exists", (Object)Boolean.TRUE).put((Object)"Boolean.FALSE", (Object)Boolean.TRUE).put((Object)"filter", (Object)Boolean.TRUE).put((Object)"floor", (Object)Boolean.TRUE).put((Object)"fold-left", (Object)Boolean.TRUE).put((Object)"fold-right", (Object)Boolean.TRUE).put((Object)"for-each", (Object)Boolean.TRUE).put((Object)"for-each-pair", (Object)Boolean.TRUE).put((Object)"format-date", (Object)Boolean.TRUE).put((Object)"format-dateTime", (Object)Boolean.TRUE).put((Object)"format-integer", (Object)Boolean.TRUE).put((Object)"format-number", (Object)Boolean.TRUE).put((Object)"format-time", (Object)Boolean.TRUE).put((Object)"function-arity", (Object)Boolean.TRUE).put((Object)"function-available", (Object)Boolean.TRUE).put((Object)"function-lookup", (Object)Boolean.TRUE).put((Object)"function-name", (Object)Boolean.TRUE).put((Object)"generate-id", (Object)Boolean.TRUE).put((Object)"has-children", (Object)Boolean.TRUE).put((Object)"head", (Object)Boolean.TRUE).put((Object)"hours-from-dateTime", (Object)Boolean.TRUE).put((Object)"hours-from-duration", (Object)Boolean.TRUE).put((Object)"hours-from-time", (Object)Boolean.TRUE).put((Object)"id", (Object)Boolean.TRUE).put((Object)"idref", (Object)Boolean.TRUE).put((Object)"implicit-timezone", (Object)Boolean.TRUE).put((Object)"in-scope-prefixes", (Object)Boolean.TRUE).put((Object)"index-of", (Object)Boolean.TRUE).put((Object)"innermost", (Object)Boolean.TRUE).put((Object)"insert-before", (Object)Boolean.TRUE).put((Object)"iri-to-uri", (Object)Boolean.TRUE).put((Object)"json-doc", (Object)Boolean.FALSE).put((Object)"json-to-xml", (Object)Boolean.TRUE).put((Object)"key", (Object)Boolean.TRUE).put((Object)"lang", (Object)Boolean.TRUE).put((Object)"last", (Object)Boolean.TRUE).put((Object)"load-xquery-module", (Object)Boolean.FALSE).put((Object)"local-name", (Object)Boolean.TRUE).put((Object)"local-name-from-QName", (Object)Boolean.TRUE).put((Object)"lower-case", (Object)Boolean.TRUE).put((Object)"matches", (Object)Boolean.TRUE).put((Object)"max", (Object)Boolean.TRUE).put((Object)"min", (Object)Boolean.TRUE).put((Object)"minutes-from-dateTime", (Object)Boolean.TRUE).put((Object)"minutes-from-duration", (Object)Boolean.TRUE).put((Object)"minutes-from-time", (Object)Boolean.TRUE).put((Object)"month-from-date", (Object)Boolean.TRUE).put((Object)"month-from-dateTime", (Object)Boolean.TRUE).put((Object)"months-from-duration", (Object)Boolean.TRUE).put((Object)"name", (Object)Boolean.TRUE).put((Object)"namespace-uri", (Object)Boolean.TRUE).put((Object)"namespace-uri-for-prefix", (Object)Boolean.TRUE).put((Object)"namespace-uri-from-QName", (Object)Boolean.TRUE).put((Object)"nilled", (Object)Boolean.TRUE).put((Object)"node-name", (Object)Boolean.TRUE).put((Object)"normalize-space", (Object)Boolean.TRUE).put((Object)"normalize-unicode", (Object)Boolean.TRUE).put((Object)"not", (Object)Boolean.TRUE).put((Object)"number", (Object)Boolean.TRUE).put((Object)"one-or-more", (Object)Boolean.TRUE).put((Object)"outermost", (Object)Boolean.TRUE).put((Object)"parse-ietf-date", (Object)Boolean.TRUE).put((Object)"parse-json", (Object)Boolean.FALSE).put((Object)"parse-xml", (Object)Boolean.FALSE).put((Object)"parse-xml-fragment", (Object)Boolean.FALSE).put((Object)"path", (Object)Boolean.TRUE).put((Object)"position", (Object)Boolean.TRUE).put((Object)"prefix-from-QName", (Object)Boolean.TRUE).put((Object)"put", (Object)Boolean.TRUE).put((Object)"QName", (Object)Boolean.TRUE).put((Object)"random-number-generator", (Object)Boolean.TRUE).put((Object)"regex-group", (Object)Boolean.TRUE).put((Object)"remove", (Object)Boolean.TRUE).put((Object)"replace", (Object)Boolean.TRUE).put((Object)"resolve-QName", (Object)Boolean.TRUE).put((Object)"resolve-uri", (Object)Boolean.TRUE).put((Object)"reverse", (Object)Boolean.TRUE).put((Object)"root", (Object)Boolean.TRUE).put((Object)"round", (Object)Boolean.TRUE).put((Object)"round-half-to-even", (Object)Boolean.TRUE).put((Object)"seconds-from-dateTime", (Object)Boolean.TRUE).put((Object)"seconds-from-duration", (Object)Boolean.TRUE).put((Object)"seconds-from-time", (Object)Boolean.TRUE).put((Object)"serialize", (Object)Boolean.TRUE).put((Object)"snapshot", (Object)Boolean.TRUE).put((Object)"sort", (Object)Boolean.TRUE).put((Object)"starts-with", (Object)Boolean.TRUE).put((Object)"static-base-uri", (Object)Boolean.TRUE).put((Object)"stream-available", (Object)Boolean.FALSE).put((Object)"string", (Object)Boolean.TRUE).put((Object)"string-join", (Object)Boolean.TRUE).put((Object)"string-length", (Object)Boolean.TRUE).put((Object)"string-to-codepoints", (Object)Boolean.TRUE).put((Object)"subsequence", (Object)Boolean.TRUE).put((Object)"substring", (Object)Boolean.TRUE).put((Object)"substring-after", (Object)Boolean.TRUE).put((Object)"substring-before", (Object)Boolean.TRUE).put((Object)"sum", (Object)Boolean.TRUE).put((Object)"system-property", (Object)Boolean.FALSE).put((Object)"tail", (Object)Boolean.TRUE).put((Object)"timezone-from-date", (Object)Boolean.TRUE).put((Object)"timezone-from-dateTime", (Object)Boolean.TRUE).put((Object)"timezone-from-time", (Object)Boolean.TRUE).put((Object)"tokenize", (Object)Boolean.TRUE).put((Object)"trace", (Object)Boolean.TRUE).put((Object)"transform", (Object)Boolean.TRUE).put((Object)"translate", (Object)Boolean.TRUE).put((Object)"Boolean.TRUE", (Object)Boolean.TRUE).put((Object)"type-available", (Object)Boolean.FALSE).put((Object)"unordered", (Object)Boolean.TRUE).put((Object)"unparsed-entity-public-id", (Object)Boolean.TRUE).put((Object)"unparsed-entity-uri", (Object)Boolean.TRUE).put((Object)"unparsed-text", (Object)Boolean.FALSE).put((Object)"unparsed-text-available", (Object)Boolean.FALSE).put((Object)"unparsed-text-lines", (Object)Boolean.FALSE).put((Object)"upper-case", (Object)Boolean.TRUE).put((Object)"uri-collection", (Object)Boolean.FALSE).put((Object)"xml-to-json", (Object)Boolean.TRUE).put((Object)"year-from-date", (Object)Boolean.TRUE).put((Object)"year-from-dateTime", (Object)Boolean.TRUE).put((Object)"years-from-duration", (Object)Boolean.TRUE).put((Object)"zero-or-one", (Object)Boolean.TRUE).build();
    private static final Set<String> SAFE_OXY_FUNCTIONS = ImmutableSet.of((Object)"allows-child-element", (Object)"allows-global-element", (Object)"platform", (Object)"is-editable-element", (Object)"is-required-element", (Object)"current-selected-element", (Object[])new String[]{"selected-elements"});
    private static final Set<Class<?>> SAFE_EXPRESSION_TYPES = ImmutableSet.of(RootExpression.class, AxisExpression.class, Literal.class, StringLiteral.class, ContextItemExpression.class);
    private static final Set<Class<?>> EXPRESSION_DEPENDING_ON_OPERANDS = ImmutableSet.of(ForExpression.class, LetExpression.class, LocalVariableReference.class, Choose.class, CardinalityChecker.class, HomogeneityChecker.class, (Object[])new Class[]{SlashExpression.class, AndExpression.class, OrExpression.class, VennExpression.class, FilterExpression.class, SquareArrayConstructor.class, GeneralComparison.class, GeneralComparison20.class, Block.class});

    public void check(String string) throws UnsafeXPathException {
        try {
            IndependentContext independentContext = new IndependentContext();
            independentContext.setNamespaceResolver((NamespaceResolver)new _b());
            Expression expression = new XPathParser((StaticContext)independentContext){

                public Expression reportMissingFunction(int n2, StructuredQName structuredQName, Expression[] expressionArray, List<String> list) throws XPathException {
                    if (SAFE_OXY_FUNCTIONS.contains(structuredQName.getLocalPart())) {
                        return Literal.makeEmptySequence();
                    }
                    return super.reportMissingFunction(n2, structuredQName, expressionArray, list);
                }
            }.parse(string, 0, 0, (StaticContext)independentContext);
            this.check(expression);
        }
        catch (XPathException xPathException) {
            throw new UnsafeXPathException(xPathException.getMessage());
        }
    }

    private void check(Expression expression) throws UnsafeXPathException {
        if (!SAFE_EXPRESSION_TYPES.contains(expression.getClass())) {
            if (EXPRESSION_DEPENDING_ON_OPERANDS.contains(expression.getClass())) {
                this.checkOperands(expression);
            } else if (expression instanceof SystemFunctionCall) {
                this.checkFunction(((SystemFunctionCall)expression).getFunctionName());
                this.checkOperands(expression);
            } else {
                throw new UnsafeXPathException("Expression not considered safe: " + expression.getClass().getName() + " " + expression.toString());
            }
        }
    }

    private void checkFunction(StructuredQName structuredQName) throws UnsafeXPathException {
        if ("http://www.w3.org/2005/xpath-functions".equals(structuredQName.getURI())) {
            this.checkArgument(SAFE_BUILTIN_FUNCTIONS.containsKey(structuredQName.getLocalPart()), "Unkown function: " + structuredQName.getLocalPart());
            this.checkArgument(SAFE_BUILTIN_FUNCTIONS.get(structuredQName.getLocalPart()), "Unsafe function: " + structuredQName.getLocalPart());
        } else if ("http://www.oxygenxml.com/ns/author/xpath-extension-functions".equals(structuredQName.getURI())) {
            this.checkArgument(SAFE_OXY_FUNCTIONS.contains(structuredQName.getLocalPart()), "Unsafe function: " + structuredQName.getLocalPart());
        } else {
            throw new IllegalArgumentException("Unsafe namespace " + structuredQName.getURI());
        }
    }

    private void checkArgument(boolean bl, String string) throws UnsafeXPathException {
        if (!bl) {
            throw new UnsafeXPathException(string);
        }
    }

    private void checkOperands(Expression expression) throws UnsafeXPathException {
        for (Operand operand : expression.operands()) {
            this.check(operand.getChildExpression());
        }
    }

    private static final class _b
    implements NamespaceResolver {
        private _b() {
        }

        public Iterator<String> iteratePrefixes() {
            return Collections.emptyListIterator();
        }

        public NamespaceUri getURIForPrefix(String string, boolean bl) {
            return NamespaceUri.of((String)"http://oxygenxml.com/ns/fake");
        }
    }

    @SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
    public static class UnsafeXPathException
    extends Exception {
        public UnsafeXPathException(String string) {
            super(string);
        }
    }
}

