/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.util.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.Options;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.NONE, methods=SkipLevel.PUBLIC)
public final class SecureXMLReader {
    private static final Logger b = LoggerFactory.getLogger((String)SecureXMLReader.class.getName());

    private SecureXMLReader() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void secureReader(XMLReader xMLReader) {
        SecureXMLReader.secureReader(xMLReader, false);
    }

    public static void secureReader(XMLReader xMLReader, boolean bl) {
        if (bl || Options.getInstance().getBooleanProperty("enable.secure.processing")) {
            block5: {
                try {
                    xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    if (xMLReader instanceof XMLParser) break block5;
                    b.warn("Cannot secure XML reader", (Throwable)sAXException);
                }
            }
            try {
                int n2 = bl ? 300000 : Options.getInstance().getIntegerProperty("Entity.expansion.limit");
                int n3 = bl ? 3000 : Options.getInstance().getIntegerProperty("maxOccur.node.limit");
                SecurityManager securityManager = new SecurityManager();
                securityManager.setEntityExpansionLimit(n2);
                securityManager.setMaxOccurNodeLimit(n3);
                xMLReader.setProperty("http://apache.org/xml/properties/security-manager", securityManager);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                b.warn("Cannot set expansion limit", (Throwable)sAXException);
            }
        }
    }

    public static void parse(XMLReader xMLReader, String string) throws IOException, SAXException {
        SecureXMLReader.parse(xMLReader, string, false);
    }

    public static void parse(XMLReader xMLReader, String string, boolean bl) throws IOException, SAXException {
        SecureXMLReader.secureReader(xMLReader, bl);
        xMLReader.parse(string);
    }

    public static void parse(XMLReader xMLReader, InputStream inputStream) throws IOException, SAXException {
        SecureXMLReader.parse(xMLReader, new InputSource(inputStream));
    }

    public static void parse(XMLReader xMLReader, Reader reader) throws IOException, SAXException {
        SecureXMLReader.parse(xMLReader, new InputSource(reader));
    }

    public static void parse(XMLReader xMLReader, InputSource inputSource) throws IOException, SAXException {
        SecureXMLReader.secureReader(xMLReader);
        xMLReader.parse(inputSource);
    }
}

