/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util.editorvars;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.DocumentTypeRepository;
import ro.sync.exml.workspace.api.editor.documenttype.DocumentTypeInformation;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class FrameworkAssetUrlObfuscator {
    public static final String h = "https://www.oxygenxml.com/cannotObfuscateAssetUrl";
    private static final Pattern f = Pattern.compile("^@(.*?)/(.+)");
    private static final String d = "NO_DT";
    private static final String g = FrameworkAssetUrlObfuscator.b();
    private static final String b = "jar";
    private static final int e = "jar".length() + 1;
    private static final Logger c = LoggerFactory.getLogger(FrameworkAssetUrlObfuscator.class);

    private FrameworkAssetUrlObfuscator() {
    }

    public static String obfuscateSafe(DocumentTypeInformation documentTypeInformation, String string) {
        try {
            return FrameworkAssetUrlObfuscator.g(documentTypeInformation, string);
        }
        catch (Exception exception) {
            c.warn(exception + string, (Throwable)exception);
            return h;
        }
    }

    public static String deobfuscateSafe(String string) {
        try {
            return FrameworkAssetUrlObfuscator.f(string);
        }
        catch (Exception exception) {
            c.debug(exception + URLUtil.filterPasswords((String)String.valueOf(string)), (Throwable)exception);
            return string;
        }
    }

    public static boolean isFromLocalDrive(String string) {
        return URLUtil.isFromLocalDrive((String)string) || string != null && string.startsWith("jar:file:");
    }

    @VisibleForTesting
    static String g(DocumentTypeInformation documentTypeInformation, String string) throws _d, MalformedURLException, _c {
        String string2 = null;
        string2 = string != null && FrameworkAssetUrlObfuscator.isFromLocalDrive(string) ? (documentTypeInformation != null && documentTypeInformation.getID() != null ? FrameworkAssetUrlObfuscator.h(documentTypeInformation.getID(), documentTypeInformation.getFrameworkStoreLocation(), string) : FrameworkAssetUrlObfuscator.h(d, g, string)) : string;
        return string2;
    }

    private static String h(String string, String string2, String string3) throws MalformedURLException, _c, _d {
        Object object = URLUtil.correct((File)new File(string2).getParentFile()).toExternalForm();
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        return FrameworkAssetUrlObfuscator.d(string, new URL((String)object), new URL(string3));
    }

    @VisibleForTesting
    static String d(String string, URL uRL, URL uRL2) throws _d, MalformedURLException, _c {
        String string2;
        String string3 = null;
        if (FrameworkAssetUrlObfuscator.isFromLocalDrive(string)) {
            throw new _d("Framework ID shouldn't contain a file path.");
        }
        boolean bl = uRL2.getProtocol().equals(b);
        if (bl) {
            uRL2 = new URL(uRL2.toExternalForm().substring(e));
        }
        if ((string2 = URLUtil.makeRelative((URL)uRL, (URL)uRL2)).equals(uRL2.toString())) {
            throw new _c("Unable to make the URL relative to framework dir. The URL may point to another drive. URL: \"" + uRL2 + "\". Framework URL: \"" + uRL + "\"");
        }
        string3 = FrameworkAssetUrlObfuscator.c(new _b(string, string2, bl));
        if (c.isDebugEnabled()) {
            c.debug(" Ofuscate     url: \"" + URLUtil.filterPasswords((String)String.valueOf(uRL2)) + "\"\n        docTypeId: \"" + string + "\"\n            frUrl: \"" + URLUtil.filterPasswords((String)String.valueOf(uRL)) + "\"\n           relURL: \"" + string2 + "\"\n         toReturn: \"" + string3 + "\"\n");
        }
        return string3;
    }

    @VisibleForTesting
    static String f(String string) throws MalformedURLException {
        Object object = null;
        if (string != null) {
            if (string.startsWith("@")) {
                Serializable serializable;
                String string2;
                _b _b2 = FrameworkAssetUrlObfuscator.e(string);
                if (d.equals(_b2.d)) {
                    string2 = g;
                } else {
                    serializable = DocumentTypeRepository.getInstance().getDocumentTypeDescriptor(_b2.d);
                    string2 = serializable.getStoreLocation();
                }
                serializable = URLUtil.correct((File)new File(string2));
                object = (_b2.b ? "jar:" : "") + new URL((URL)serializable, _b2.c).toExternalForm();
                if (c.isDebugEnabled()) {
                    c.debug("Deobfuscate    url: \"" + URLUtil.filterPasswords((String)String.valueOf(string)) + "\"\n       urlParts.id: \"" + _b2.d + "\"\n     urlParts.relP: \"" + _b2.c + "\"\n        frLocation: \"" + string2 + "\"\n          toReturn: \"" + (String)object + "\"\n");
                }
            } else {
                if (FrameworkAssetUrlObfuscator.isFromLocalDrive(string)) {
                    throw new MalformedURLException("The URL represent a fully qulified file path.");
                }
                object = string;
            }
        }
        return object;
    }

    private static String c(_b _b2) {
        String string = URLUtil.encodeURIComponent((String)_b2.d);
        return (_b2.b ? "@@" : "@") + string + "/" + _b2.c;
    }

    private static _b e(String string) throws MalformedURLException {
        Matcher matcher = f.matcher(string);
        matcher.find();
        try {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            boolean bl = string2.startsWith("@");
            if (bl) {
                string2 = string2.substring(1);
            }
            return new _b(URLUtil.decodeURIComponent((String)string2), string3, bl);
        }
        catch (IllegalStateException illegalStateException) {
            MalformedURLException malformedURLException = new MalformedURLException("Could not decode URL");
            malformedURLException.initCause(illegalStateException);
            throw malformedURLException;
        }
    }

    private static String b() {
        String string = System.getProperty("oxygen.data.dir");
        File file = string != null ? new File(string, "fake.framework") : new File("fake.framework");
        return file.getAbsolutePath();
    }

    private static class _d
    extends Exception {
        private static final long b = 1L;

        public _d(String string) {
            super(string);
        }
    }

    private static class _c
    extends IOException {
        private static final long b = 1L;

        public _c(String string) {
            super(string);
        }
    }

    private static class _b {
        private final String d;
        private final String c;
        private final boolean b;

        public _b(String string, String string2, boolean bl) {
            this.d = string;
            this.c = string2;
            this.b = bl;
        }
    }
}

