/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ui.table;

import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TableColumnInfo
implements PersistentObject {
    private int modelIndex;
    private int width;
    private int minWidth;
    private int maxWidth;
    private boolean resizeable;
    private String tag;
    private boolean isHideable = true;
    protected boolean isHidden = false;

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getWidth() {
        return this.width;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int n2) {
        this.minWidth = n2;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n2) {
        this.maxWidth = n2;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public TableColumnInfo() {
    }

    public TableColumnInfo(String string, int n2, int n3, int n4, int n5, boolean bl) {
        this(string, n2, n3, n4, n5, bl, true, false);
    }

    public TableColumnInfo(String string, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        this.tag = string;
        this.modelIndex = n2;
        this.width = n3;
        this.minWidth = n4;
        this.maxWidth = n5;
        this.resizeable = bl;
        this.isHideable = bl2;
        this.isHidden = bl3;
    }

    public String toString() {
        return "Column info[tag = " + this.tag + "; modelIndex=" + this.modelIndex + "; width=" + this.width + "; minWidth=" + this.minWidth + "; maxWidth=" + this.maxWidth + "; resizable=" + this.resizeable + "; isHideable=" + this.isHideable + "; isHidden=" + this.isHidden + "]";
    }

    @Override
    public Object clone() {
        return new TableColumnInfo(this.tag, this.modelIndex, this.width, this.minWidth, this.maxWidth, this.resizeable, this.isHideable, this.isHidden);
    }

    public void setWidth(int n2) {
        this.width = n2 < this.minWidth ? this.minWidth : (n2 > this.maxWidth ? this.maxWidth : n2);
    }

    public boolean equals(Object object) {
        return object instanceof TableColumnInfo && ((TableColumnInfo)object).modelIndex == this.modelIndex;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.modelIndex < 0 || this.width < 0) {
            throw new InvalidPersistentObjException("Invalid table column info");
        }
        if (this.minWidth < 0) {
            this.minWidth = 15;
        }
        if (this.maxWidth < 0) {
            this.maxWidth = 500;
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isHideable() {
        return this.isHideable;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void setHideable(boolean bl) {
        this.isHideable = bl;
    }

    public boolean isHidden() {
        return this.isHidden;
    }
}

