/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ui.hidpi;

import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.ui.hidpi.c;
import ro.sync.ui.hidpi.e;
import ro.sync.ui.hidpi.f;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class RetinaDetector {
    protected boolean isEnabled = true;
    protected float scalingFactor = 1.0f;
    private _b retinaType;
    public static float[] ALLOWED_ICON_SCALING_FACTORS = new float[]{1.0f, 2.0f, 4.0f, 8.0f};
    private static RetinaDetector instance;

    public final boolean isRetina() {
        return this.isEnabled && this.scalingFactor != 1.0f;
    }

    public final float getScalingFactor() {
        float f2 = this.isRetina() ? this.scalingFactor : 1.0f;
        return f2;
    }

    public float getIconScalingFactor() {
        float f2 = 1.0f;
        String string = System.getProperty("com.oxygenxml.hidpi.icon.scaling");
        if (string != null) {
            try {
                f2 = NumberParserUtil.parseFloat((String)string);
            }
            catch (NumberFormatException numberFormatException) {
                f2 = 1.0f;
            }
        } else if (this.isRetina()) {
            int n2 = 0;
            float f3 = Float.MAX_VALUE;
            for (int i2 = 0; i2 < ALLOWED_ICON_SCALING_FACTORS.length; ++i2) {
                float f4;
                float f5 = 0.0f;
                if (i2 > 0) {
                    f5 = (ALLOWED_ICON_SCALING_FACTORS[i2 - 1] - ALLOWED_ICON_SCALING_FACTORS[i2]) / 2.0f;
                }
                if ((f4 = this.scalingFactor - ALLOWED_ICON_SCALING_FACTORS[i2]) < f3 && f4 >= f5) {
                    f3 = f4;
                    n2 = i2;
                }
                if (f4 <= 0.0f) break;
            }
            f2 = ALLOWED_ICON_SCALING_FACTORS[n2];
        }
        return f2;
    }

    public final int[] scaleForRetinaIcons(int[] nArray) {
        float f2 = this.getIconScalingFactor();
        float f3 = this.getScalingFactor();
        if (this.isRetina() && this.getRetinaType() == _b.c && f3 < 2.0f) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = (int)((float)nArray[i2] * f2 / f3);
            }
        }
        return nArray;
    }

    protected RetinaDetector() {
    }

    public static RetinaDetector getInstance() {
        if (instance == null) {
            instance = PlatformDetector.isMacOS() ? (PlatformDetector.isEclipse() ? new c() : new f()) : (PlatformDetector.isWin() ? (PlatformDetector.isEclipse() ? new e() : new c()) : (PlatformDetector.isLinux() ? new c() : new RetinaDetector()));
        }
        return instance;
    }

    public static void setInstance(RetinaDetector retinaDetector) {
        instance = retinaDetector;
    }

    protected static void resetInstance() {
        instance = null;
        RetinaDetector.getInstance();
    }

    public final _b getRetinaType() {
        if (this.retinaType == null) {
            this.retinaType = this.determineRetinaType();
        }
        return this.retinaType;
    }

    protected _b determineRetinaType() {
        _b _b2 = _b.d;
        if (this.isRetina()) {
            _b2 = _b.c;
        }
        return _b2;
    }

    @Deprecated
    public boolean isRetinaNoImplicitSupport() {
        return false;
    }

    @Deprecated
    public float getSystemScalingFactor() {
        return 1.0f;
    }

    public static final class _b
    extends Enum<_b> {
        public static final /* enum */ _b d = new _b();
        public static final /* enum */ _b c = new _b();
        private static final /* synthetic */ _b[] b;

        public static _b[] values() {
            return (_b[])b.clone();
        }

        public static _b valueOf(String string) {
            return Enum.valueOf(_b.class, string);
        }

        private static /* synthetic */ _b[] b() {
            return new _b[]{d, c};
        }

        static {
            b = _b.b();
        }
    }
}

