/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.template;

import java.io.IOException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.editor.xmleditor.transform.CancelledException;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.template.BuiltinEditorTemplate;
import ro.sync.template.EditorTemplateWithContent;
import ro.sync.template.TemplateContentInfo;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SimpleEditorTemplate
implements EditorTemplateWithContent,
BuiltinEditorTemplate {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleEditorTemplate.class.getName());
    private String description;
    private String extension;
    private String content;
    private String customizationPageID;

    public SimpleEditorTemplate() {
    }

    public SimpleEditorTemplate(String string, String string2, String string3, String string4) {
        this.description = string;
        this.extension = string2;
        this.customizationPageID = string4;
        this.content = string3;
    }

    public SimpleEditorTemplate(String string, String string2) {
        this(string, string2, null, null);
    }

    public SimpleEditorTemplate(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    @Override
    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public int getTemplateType() {
        return 1;
    }

    @Override
    public TemplateContentInfo getContentInfo(String string) {
        TemplateContentInfo templateContentInfo = null;
        String string2 = this.content;
        if (string2 != null) {
            int n2 = string2.indexOf("${caret}");
            string2 = string2.replaceAll(Pattern.quote("${caret}"), "");
            templateContentInfo = new TemplateContentInfo(string2, n2);
        }
        return templateContentInfo;
    }

    @Override
    public TemplateContentInfo getContentInfo(String string, boolean bl) throws IOException, CancelledException {
        return this.getContentInfo(string);
    }

    @Override
    public TemplateContentInfo getContentInfo(String string, boolean bl, boolean bl2) throws IOException, CancelledException {
        return this.getContentInfo(string, bl2);
    }

    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public int getCaretPosition() {
        int n2 = this.content != null ? this.content.indexOf("${caret}") : -1;
        return n2 != -1 ? n2 : 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SimpleEditorTemplate) {
            SimpleEditorTemplate simpleEditorTemplate = (SimpleEditorTemplate)object;
            bl = Equaler.verifyEquals((Object)this.extension, (Object)simpleEditorTemplate.extension) && Equaler.verifyEquals((Object)this.content, (Object)simpleEditorTemplate.content) && Equaler.verifyEquals((Object)this.description, (Object)simpleEditorTemplate.description);
        }
        return bl;
    }

    public int hashCode() {
        return this.description != null ? this.description.hashCode() : 1;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.description == null || this.extension == null) {
            throw new InvalidPersistentObjException("Invalid editor template: description " + this.description + ", extension " + this.extension + " content " + this.content);
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public String getAdditionalInformation() {
        return null;
    }

    @Override
    public boolean isCustomizable() {
        return this.customizationPageID != null;
    }

    @Override
    public String getCustomizePageID() {
        return this.customizationPageID;
    }

    @Override
    public String getLongDescription() {
        return null;
    }

    @Override
    public String getTypeProperty() {
        return "simple_editor";
    }

    @Override
    public String getFilenamePrefix() {
        return null;
    }

    @Override
    public String getFilenameSuffix() {
        return null;
    }

    public String toString() {
        return "SimpleEditorTemplate: description " + this.description + ", extension " + this.extension + " content " + this.content;
    }
}

