/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.template;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.EditorTemplate;
import ro.sync.template.d;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public abstract class AbstractTemplate
implements EditorTemplate {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractTemplate.class.getName());
    public static final String SMALL_ICON = "smallIcon";
    public static final String BIG_ICON = "bigIcon";
    public static final String LONG_DESC_REF = "longDescriptionReference";
    public static final String TYPE = "type";
    public static final String FILENAME_PREFIX = "filenamePrefix";
    public static final String FILENAME_SUFFIX = "filenameSuffix";
    public static final String DISPLAY_NAME = "displayName";
    public static final String EXPAND_ED_VARS_INCLUDE_FILTER = "expandEditorVariablesIncludeFilter";
    public static final String EXPAND_ED_VARS_EXCLUDE_FILTER = "expandEditorVariablesExcludeFilter";
    protected File templateLocation;
    protected final String sourceInformation;
    private boolean isFromFrameworks = false;
    private String smallIconPath = null;
    private String bigIconPath = null;
    private d longDescriptionProvider = null;
    private String typeProperty = null;
    protected String filenamePrefix = null;
    protected String filenameSuffix = null;
    private String displayName = null;

    @Deprecated
    public AbstractTemplate(File file, String string, boolean bl, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.templateLocation = file;
        this.sourceInformation = string;
        this.isFromFrameworks = bl;
        this.smallIconPath = string2;
        this.bigIconPath = string3;
        this.typeProperty = string4;
        this.filenamePrefix = string5;
        this.filenameSuffix = string6;
        this.displayName = string7;
    }

    public AbstractTemplate(File file, String string, boolean bl) {
        this.templateLocation = file;
        this.sourceInformation = string;
        this.isFromFrameworks = bl;
    }

    public void setMainProperties(String string, String string2, String string3, String string4, String string5, String string6) {
        this.smallIconPath = string;
        this.bigIconPath = string2;
        this.typeProperty = string3;
        this.filenamePrefix = string4;
        this.filenameSuffix = string5;
        this.displayName = string6;
    }

    public abstract String getTemplateFileName();

    @Override
    public String getExtension() {
        return URLUtil.getExtension((String)this.getTemplateFileName());
    }

    @Override
    public String getDescription() {
        Object object = this.getName();
        if (this.sourceInformation != null) {
            object = this.sourceInformation + " - " + (String)object;
        }
        return object;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractTemplate) {
            if (object.getClass().equals(this.getClass())) {
                AbstractTemplate abstractTemplate = (AbstractTemplate)object;
                File file = abstractTemplate.templateLocation;
                if (file != null && file.getAbsolutePath().equals(this.templateLocation.getAbsolutePath())) {
                    return Equaler.verifyEquals((Object)this.getAdditionalInformation(), (Object)abstractTemplate.getAdditionalInformation());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getAdditionalInformation() != null) {
            return this.getAdditionalInformation().hashCode() + this.templateLocation.hashCode();
        }
        if (this.templateLocation != null) {
            return this.templateLocation.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public String getSource() {
        return this.templateLocation.getAbsolutePath();
    }

    public static int getTemplateType(File file) {
        int n2 = 2;
        String string = file.getName();
        if (string.endsWith(".bin")) {
            n2 = 3;
        } else if (string.endsWith(".zxpr")) {
            n2 = 4;
        }
        return n2;
    }

    @Override
    public Object clone() {
        try {
            AbstractTemplate abstractTemplate = (AbstractTemplate)super.clone();
            abstractTemplate.templateLocation = this.templateLocation;
            return abstractTemplate;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public String getName() {
        String string = null;
        string = this.displayName != null && !this.displayName.isEmpty() ? this.displayName : URLUtil.removeExtension((String)this.getTemplateFileName());
        return string;
    }

    public File getLocation() {
        return this.templateLocation;
    }

    @Override
    public String getAdditionalInformation() {
        return this.sourceInformation;
    }

    public boolean isFromFrameworks() {
        return this.isFromFrameworks;
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public String getCustomizePageID() {
        return null;
    }

    public String getSmallIconPath() {
        return this.smallIconPath;
    }

    public String getBigIconPath() {
        return this.bigIconPath;
    }

    @Override
    public int getCaretPosition() {
        return 0;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"longDescriptionProvider"};
    }

    @Override
    public String getLongDescription() {
        return this.longDescriptionProvider != null ? this.longDescriptionProvider.b() : null;
    }

    public void setLongDescriptionProvider(d d2) {
        this.longDescriptionProvider = d2;
    }

    @Override
    public String getTypeProperty() {
        return this.typeProperty;
    }

    @Override
    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    @Override
    public String getFilenameSuffix() {
        return this.filenameSuffix;
    }
}

