/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.options;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.FileTypeAssociation;
import ro.sync.exml.editor.og;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNFileTypeAssociation
implements PersistentObject,
Comparable {
    private static final Logger logger = LoggerFactory.getLogger((String)SVNFileTypeAssociation.class.getName());
    public static final int ASSOCIATION_INTERNAL_EDITOR = 0;
    public static final int ASSOCIATION_DEFAULT_SYS_APP = 1;
    public static final int ASSOCIATION_CUSTOM_SYS_APP = 2;
    public static final String EDITOR_IMAGE_PREVIEW = "Image Preview";
    private static SVNFileTypeAssociation[] DEFAULT;
    private String extension;
    private int associationType = -1;
    private String editor;
    private String options;

    public SVNFileTypeAssociation() {
    }

    public SVNFileTypeAssociation(String string, int n2, String string2, String string3) {
        this.extension = string;
        this.associationType = n2;
        this.editor = string2;
        this.options = string3;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.extension == null || this.associationType == -1) {
            throw new InvalidPersistentObjException("'extension' or 'associationType' is invalid.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public String toString() {
        Object object = "[SVNFileAssociationType: ";
        object = (String)object + "[extension=" + this.extension + "]";
        object = (String)object + "[type=" + this.associationType + "]";
        object = (String)object + "[editor=" + this.editor + "]";
        object = (String)object + "[options=" + this.options + "]";
        object = (String)object + "]";
        return object;
    }

    public String getExtension() {
        return this.extension;
    }

    public int getAssociationType() {
        return this.associationType;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getOptions() {
        return this.options;
    }

    public static SVNFileTypeAssociation[] getDefault() {
        if (DEFAULT == null) {
            FileTypeAssociation[] fileTypeAssociationArray = og.q();
            DEFAULT = new SVNFileTypeAssociation[fileTypeAssociationArray.length];
            for (int i2 = 0; i2 < fileTypeAssociationArray.length; ++i2) {
                SVNFileTypeAssociation sVNFileTypeAssociation;
                FileTypeAssociation fileTypeAssociation = fileTypeAssociationArray[i2];
                SVNFileTypeAssociation.DEFAULT[i2] = sVNFileTypeAssociation = new SVNFileTypeAssociation(fileTypeAssociation.getExtension().toLowerCase(), 0, fileTypeAssociation.getContentType(), null);
            }
        }
        return DEFAULT;
    }

    public int compareTo(Object object) {
        int n2 = -1;
        if (object instanceof SVNFileTypeAssociation) {
            SVNFileTypeAssociation sVNFileTypeAssociation = (SVNFileTypeAssociation)object;
            n2 = this.extension.compareToIgnoreCase(sVNFileTypeAssociation.getExtension());
        }
        return n2;
    }

    public static final Comparator getComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                int n2 = -1;
                if (object instanceof SVNFileTypeAssociation) {
                    SVNFileTypeAssociation sVNFileTypeAssociation = (SVNFileTypeAssociation)object;
                    n2 = sVNFileTypeAssociation.compareTo(object2);
                }
                return n2;
            }
        };
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SVNFileTypeAssociation) {
            SVNFileTypeAssociation sVNFileTypeAssociation = (SVNFileTypeAssociation)object;
            bl = this.extension.equalsIgnoreCase(sVNFileTypeAssociation.getExtension());
        }
        return bl;
    }

    public int hashCode() {
        return this.extension.hashCode();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }
}

