/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.outline;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableList;
import ro.sync.outline.PathItem;
import ro.sync.outline.y;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TokenIndexPath
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)TokenIndexPath.class.getName());
    public static final String SEPARATOR = ",";
    private SerializableList<PathItem> pathItems = new SerializableList();

    public TokenIndexPath() {
    }

    public TokenIndexPath(String string) throws y {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PathItem pathItem = new PathItem(string2);
                this.addPathItem(pathItem);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new y(noSuchElementException.getMessage());
        }
    }

    public void addPathItem(PathItem pathItem) {
        this.pathItems.add(pathItem);
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            PathItem pathItem = (PathItem)this.pathItems.get(i2);
            stringBuffer.append(pathItem.serialize());
            if (i2 >= n2 - 1) continue;
            stringBuffer.append(SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public String getXPathRepresentation() {
        return this.getXPathRepresentation(true);
    }

    public String getXPathRepresentation(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("/");
            PathItem pathItem = (PathItem)this.pathItems.get(i2);
            stringBuilder.append(pathItem.toXPathString(bl));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TokenIndexPath) {
            return Equaler.verifyListEquals(this.pathItems, ((TokenIndexPath)object).pathItems);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.pathItems != null) {
            int n3 = this.pathItems.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += ((PathItem)this.pathItems.get(i2)).hashCode();
            }
        }
        return n2;
    }

    public String toString() {
        return String.valueOf(this.pathItems);
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.pathItems == null) {
            throw new InvalidPersistentObjException("The pathItems is null.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public SerializableList<PathItem> getPathItems() {
        return this.pathItems;
    }

    public PathItem[] getPathItemsArrayForTests() {
        return this.pathItems.toArray(new PathItem[0]);
    }

    @Override
    public Object clone() {
        TokenIndexPath tokenIndexPath = null;
        try {
            tokenIndexPath = (TokenIndexPath)super.clone();
            if (this.pathItems != null) {
                tokenIndexPath.pathItems = (SerializableList)this.pathItems.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return tokenIndexPath;
    }
}

