/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.OutputStreamCloseListener;
import ro.sync.basic.io.OutputStreamCloseNotifier;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.options.Options;
import ro.sync.net.protocol.j;
import ro.sync.net.protocol.sftp.b;
import ro.sync.net.protocol.sftp.c;
import ro.sync.net.protocol.sftp.g;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class SFTPURLConnection
extends URLConnection
implements b,
OutputStreamCloseListener,
j {
    private static final org.slf4j.Logger y = LoggerFactory.getLogger((String)SFTPURLConnection.class.getName());
    private static final String x = "diffie-hellman-group-exchange-sha256";
    public static final String CONTENT_LENGTH = "content-length";
    public static final String LAST_MODIFIED = "last-modified";
    private long ab;
    private long w;
    private ChannelSftp z;

    public SFTPURLConnection(URL uRL) {
        super(uRL);
        if (y.isDebugEnabled()) {
            y.debug("Created SFTP connection: " + URLUtil.clearUserInfo((URL)uRL));
        }
    }

    @Override
    public void connect() throws IOException {
        block15: {
            if (y.isDebugEnabled()) {
                y.debug("On connect()");
            }
            try {
                block14: {
                    Session session = SFTPURLConnection.createSession(this.url);
                    if (y.isDebugEnabled()) {
                        y.debug("Connecting...");
                    }
                    session.connect();
                    this.z = (ChannelSftp)session.openChannel("sftp");
                    this.z.connect();
                    try {
                        this.z.setFilenameEncoding(Options.getInstance().getStringProperty("ftp.control-connection-encoding"));
                    }
                    catch (SftpException sftpException) {
                        if (!y.isDebugEnabled()) break block14;
                        y.debug("Cannot set filename encoding to channel ", (Throwable)sftpException);
                    }
                }
                if (y.isDebugEnabled()) {
                    y.debug("Connected.");
                }
                this.connected = this.z.isConnected();
                try {
                    Vector vector = this.z.ls(this.url.getPath());
                    if (vector.size() == 1) {
                        ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)vector.get(0);
                        this.ab = lsEntry.getAttrs().getMTime();
                        this.w = lsEntry.getAttrs().getSize();
                        if (y.isDebugEnabled()) {
                            y.debug("The modified time is: " + this.ab);
                        }
                        if (y.isDebugEnabled()) {
                            y.debug("The content length is: " + this.w);
                        }
                        break block15;
                    }
                    y.debug("Probably the file does not exist.");
                }
                catch (SftpException sftpException) {
                    if (y.isDebugEnabled()) {
                        y.debug((Object)sftpException, (Throwable)sftpException);
                    }
                }
            }
            catch (JSchException jSchException) {
                if (y.isDebugEnabled()) {
                    y.debug("Got Exception: " + jSchException, (Throwable)jSchException);
                }
                throw new IOException(jSchException.getMessage(), jSchException);
            }
        }
    }

    public static Session createSession(URL uRL) throws JSchException {
        Session session;
        block6: {
            String string;
            String string2 = null;
            String string3 = null;
            Object object = JSch.getConfig((String)"kex");
            if (object != null && !((String)object).contains(x)) {
                object = (String)object + ",diffie-hellman-group-exchange-sha256";
                if (y.isDebugEnabled()) {
                    y.debug("JSch kex set to: " + (String)object);
                }
                JSch.setConfig((String)"kex", (String)object);
            }
            JSch.setConfig((String)"MaxAuthTries", (String)"1");
            JSch jSch = new JSch();
            g g2 = null;
            String string4 = uRL.getUserInfo();
            if (string4 != null && !"".equals(string4)) {
                string3 = URLUtil.uncorrect((String)URLUtil.extractPassword((String)string4));
                string2 = URLUtil.uncorrect((String)URLUtil.extractUser((String)string4));
                string = Options.getInstance().getStringProperty("sftp.key.file");
                if (string != null && !"".equals(string)) {
                    jSch.addIdentity(string);
                }
                g2 = string3 != null && string3.length() > 0 ? new g(string3) : new g(null);
            }
            string = uRL.getHost();
            int n2 = uRL.getPort() <= 0 ? 22 : uRL.getPort();
            session = jSch.getSession(string2, string, n2);
            session.setUserInfo(g2);
            String string5 = Options.getInstance().getStringProperty("sftp.known-hosts-file");
            try {
                jSch.setKnownHosts(EditorVariables.expandEditorVariables(string5, null));
            }
            catch (JSchException jSchException) {
                if (!y.isDebugEnabled()) break block6;
                y.debug((Object)jSchException, (Throwable)jSchException);
            }
        }
        session.setConfig("HashKnownHosts", "yes");
        return session;
    }

    @Override
    public String getHeaderField(String string) {
        if (y.isDebugEnabled()) {
            y.debug("getHeaderField for " + string);
        }
        Object object = null;
        if (CONTENT_LENGTH.equals(string)) {
            object = String.valueOf(this.w);
        } else if (LAST_MODIFIED.equals(string)) {
            object = "" + this.ab;
        }
        return object;
    }

    @Override
    public String getHeaderField(int n2) {
        Object object = null;
        switch (n2) {
            case 0: {
                object = "0";
                break;
            }
            case 1: {
                object = "" + this.ab;
                break;
            }
        }
        return object;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = CONTENT_LENGTH;
                break;
            }
            case 1: {
                string = LAST_MODIFIED;
                break;
            }
        }
        return string;
    }

    @Override
    public long getLastModified() {
        return this.ab;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if ("".equals(string = this.url.getPath())) {
            string = "/";
        }
        String string2 = URLUtil.uncorrect((String)string);
        if (y.isDebugEnabled()) {
            y.debug("Input stream for:" + string2);
        }
        c c2 = null;
        try {
            c2 = new c(this.z.get(string2), this);
        }
        catch (SftpException sftpException) {
            if (y.isDebugEnabled()) {
                y.debug((Object)sftpException, (Throwable)sftpException);
            }
            throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
        }
        return c2;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if ("".equals(string = this.url.getPath())) {
            string = "/";
        }
        String string2 = URLUtil.uncorrect((String)string);
        if (y.isDebugEnabled()) {
            y.debug("Output stream for:" + string2);
        }
        OutputStreamCloseNotifier outputStreamCloseNotifier = null;
        try {
            outputStreamCloseNotifier = new OutputStreamCloseNotifier(this.z.put(string2), (OutputStreamCloseListener)this);
        }
        catch (SftpException sftpException) {
            if (y.isDebugEnabled()) {
                y.debug((Object)sftpException, (Throwable)sftpException);
            }
            throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
        }
        return outputStreamCloseNotifier;
    }

    @Override
    public void onInputStreamClose() {
        if (y.isDebugEnabled()) {
            y.debug("Call quit on the ftp from input stream close notification");
        }
        this.disconnect();
    }

    public void disconnect() {
        block4: {
            if (this.z != null) {
                this.z.quit();
                try {
                    Session session = this.z.getSession();
                    if (session != null) {
                        session.disconnect();
                    }
                }
                catch (JSchException jSchException) {
                    if (!y.isDebugEnabled()) break block4;
                    y.debug("Error during disconnect ", (Throwable)jSchException);
                }
            }
        }
    }

    public void onOutputStreamClose() throws IOException {
        if (y.isDebugEnabled()) {
            y.debug("Call quit on the ftp from output stream close notification");
        }
        this.disconnect();
    }

    public ChannelSftp getChannel() {
        return this.z;
    }

    public static String getErrorMessagesFromId(SftpException sftpException) {
        Object object = "";
        switch (sftpException.id) {
            case 2: {
                object = "File not found";
                break;
            }
            case 3: {
                object = "Permission denied";
                break;
            }
            case 4: {
                object = "Failure";
                break;
            }
            case 0: {
                object = "Succes";
                break;
            }
            case 1: {
                object = "Reached end of file";
                break;
            }
            case 5: {
                object = "Bad message";
                break;
            }
            case 6: {
                object = "No connection to server";
                break;
            }
            case 7: {
                object = "Connection to server has been lost";
                break;
            }
            case 8: {
                object = "Operation not supported";
                break;
            }
            default: {
                object = "Error";
            }
        }
        String string = sftpException.getMessage();
        if (string != null && string.trim().length() > 0) {
            object = string.startsWith((String)object) ? string + "." : (String)object + ". " + string;
        }
        return object;
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        if (this.getChannel() != null) {
            try {
                this.getChannel().rmdir(this.url.getPath());
            }
            catch (SftpException sftpException) {
                if (y.isDebugEnabled()) {
                    y.debug((Object)sftpException, (Throwable)sftpException);
                }
                if (sftpException.id == 2) {
                    try {
                        this.getChannel().rm(this.url.getPath());
                    }
                    catch (SftpException sftpException2) {
                        if (y.isDebugEnabled()) {
                            y.debug((Object)sftpException2, (Throwable)sftpException2);
                        }
                        throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException2), sftpException2);
                    }
                }
                throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    static {
        JSch.setLogger((Logger)new Logger(){

            public void log(int n2, String string) {
                this.c(n2, string);
            }

            public boolean isEnabled(int n2) {
                return this.b(n2);
            }

            private void c(int n2, String string) {
                switch (n2) {
                    case 0: {
                        y.debug(string);
                        break;
                    }
                    case 3: {
                        y.error(string);
                        break;
                    }
                    case 4: {
                        y.fatal(string);
                        break;
                    }
                    case 1: {
                        y.debug(string);
                        break;
                    }
                    case 2: {
                        y.warn(string);
                        break;
                    }
                    default: {
                        y.debug(string);
                    }
                }
            }

            private boolean b(int n2) {
                boolean bl = false;
                switch (n2) {
                    case 0: {
                        bl = y.isDebugEnabled();
                        break;
                    }
                    case 3: {
                        bl = y.isErrorEnabled();
                        break;
                    }
                    case 4: {
                        bl = y.isFatalEnabled();
                        break;
                    }
                    case 1: {
                        bl = y.isDebugEnabled();
                        break;
                    }
                    case 2: {
                        bl = y.isWarnEnabled();
                        break;
                    }
                    default: {
                        bl = y.isDebugEnabled();
                    }
                }
                return bl;
            }
        });
    }
}

