/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.e;
import ro.sync.net.protocol.file.b;
import ro.sync.net.protocol.j;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class FileURLConnection
extends URLConnection
implements e,
j,
FileBrowsingConnection {
    private static b e;
    protected File file = null;
    public static StringBuilder DEBUG_BUILDER;
    public static StringBuilder OS_DEBUG_BUILDER;
    private static final Logger d;

    public FileURLConnection(URL uRL) {
        super(uRL);
        this.file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public String getHeaderField(String string) {
        String string2 = null;
        if ("content-length".equals(string)) {
            string2 = String.valueOf(this.file.length());
        } else if ("last-modified".equals(string)) {
            string2 = new Date(this.file.lastModified()).toString();
        } else if ("content-type".equals(string) && this.file != null && !this.file.isDirectory()) {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String string3 = fileNameMap.getContentTypeFor(this.file.toString());
            if (string3 == null) {
                string3 = "text/plain";
            }
            string2 = string3;
        }
        return string2;
    }

    @Override
    public String getHeaderField(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = String.valueOf(this.file.length());
                break;
            }
            case 1: {
                string = String.valueOf(this.file.lastModified());
                break;
            }
        }
        return string;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = "content-length";
                break;
            }
            case 1: {
                string = "last-modified";
                break;
            }
        }
        return string;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (DEBUG_BUILDER != null) {
            DEBUG_BUILDER.append("GET INPUT STREAM " + this.url).append("\n");
        }
        if (d.isDebugEnabled()) {
            d.debug("GET INPUT STREAM FOR " + this.file + " exists " + this.file.exists() + " length " + this.file.length());
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        boolean bl;
        if (OS_DEBUG_BUILDER != null) {
            OS_DEBUG_BUILDER.append("GET OUTPUT STREAM " + this.url).append("\n");
        }
        if (d.isDebugEnabled()) {
            d.debug("GET OUTPUT STREAM FOR " + this.url + " size " + this.file.length());
        }
        boolean bl2 = this.file.exists();
        if (e != null && !bl2) {
            e.b(this.file);
        }
        boolean bl3 = bl = !"true".equals(System.getProperty("com.oxygenxml.classic.file.output.stream.save"));
        if (bl) {
            RandomAccessFile randomAccessFile;
            block7: {
                randomAccessFile = new RandomAccessFile(this.file, "rw");
                try {
                    randomAccessFile.setLength(0L);
                    if (d.isDebugEnabled()) {
                        d.debug("Initial length of access file after reset " + randomAccessFile.length());
                    }
                }
                catch (IOException iOException) {
                    if (randomAccessFile.length() == 0L) break block7;
                    throw iOException;
                }
            }
            return new OutputStream(){

                @Override
                public void write(int n2) throws IOException {
                    randomAccessFile.write(n2);
                }

                @Override
                public void close() throws IOException {
                    if (d.isDebugEnabled()) {
                        d.debug("CLOSE FILE AFTER WRITE");
                    }
                    randomAccessFile.close();
                    if (d.isDebugEnabled()) {
                        d.debug("CLOSE FILE AFTER WRITE2 FILE SIZE " + FileURLConnection.this.file + " with size:" + FileURLConnection.this.file.length());
                    }
                }

                @Override
                public void write(byte[] byArray, int n2, int n3) throws IOException {
                    if (d.isDebugEnabled()) {
                        d.debug("Write bytes " + new String(byArray, n2, n3));
                    }
                    randomAccessFile.write(byArray, n2, n3);
                }
            };
        }
        return new FileOutputStream(this.file){

            @Override
            public void close() throws IOException {
                super.close();
                if (d.isDebugEnabled()) {
                    d.debug("CLOSE FILE AFTER WRITE2 FILE SIZE " + FileURLConnection.this.file + " with size:" + FileURLConnection.this.file.length());
                }
            }
        };
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        if (this.file != null) {
            FileSystemUtil.deleteRecursivelly((File)this.file);
        }
    }

    public static void setFileURLConnectionListener(b b2) {
        e = b2;
    }

    public static b getListener() {
        return e;
    }

    @Override
    public List<FolderEntryDescriptor> listFolder() throws IOException {
        ArrayList<FolderEntryDescriptor> arrayList;
        block10: {
            File file;
            block9: {
                arrayList = new ArrayList<FolderEntryDescriptor>();
                String string = this.url.getPath();
                if ("/".equals(string)) break block9;
                Object object = string.startsWith("/") ? string.substring(1) : string;
                File file2 = URLUtil.getAbsoluteFileFromFileUrl((URL)this.url);
                if (!file2.isDirectory() || file2.list() == null) break block10;
                for (String string2 : file2.list()) {
                    File file3 = new File(file2, string2);
                    if (!((String)object).endsWith("/")) {
                        object = (String)object + "/";
                    }
                    String string3 = (String)object + URLUtil.encodeURIComponent((String)string2);
                    if (file3.isDirectory()) {
                        string3 = string3 + "/";
                    }
                    arrayList.add(new FolderEntryDescriptor("/" + string3));
                }
                break block10;
            }
            File[] fileArray = File.listRoots();
            if (fileArray.length > 1) {
                for (File file4 : fileArray) {
                    Object object = file4.getAbsolutePath().replace("\\", "/");
                    object = ((String)object).endsWith("/") ? object : (String)object + "/";
                    arrayList.add(new FolderEntryDescriptor("/" + (String)object));
                }
            } else if (fileArray.length == 1 && (file = fileArray[0]).isDirectory() && file.list() != null) {
                String string = file.getAbsolutePath();
                for (String string4 : file.list()) {
                    File file5 = new File(file, string4);
                    String string5 = string + "/" + URLUtil.encodeURIComponent((String)string4);
                    if (file5.isDirectory()) {
                        string5 = string5 + "/";
                    }
                    arrayList.add(new FolderEntryDescriptor("/" + string5));
                }
            }
        }
        return arrayList;
    }

    static {
        d = LoggerFactory.getLogger((String)FileURLConnection.class.getName());
    }
}

