/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Font {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private final String name;
    private final int style;
    private final int size;
    private int letterSpacing = 0;
    private String hash;
    private int hashCode = -1;
    private String[] fontNames;
    private static final Logger logger = LoggerFactory.getLogger((String)Font.class.getName());

    public Font(String string, int n2, int n3) {
        this(string, n2, n3, 0);
    }

    public Font(String string, int n2, int n3, int n4) {
        this(string, n2, n3, n4, new String[]{string});
    }

    public Font(String string, int n2, int n3, int n4, String[] stringArray) {
        this.name = string;
        this.style = n2;
        this.size = n3;
        this.letterSpacing = n4;
        this.fontNames = (String[])stringArray.clone();
        if (string != null && !string.equals(stringArray[0])) {
            logger.error("A font with a family different from its name: " + string + " f: " + stringArray[0], (Throwable)new Exception());
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int getLetterSpacing() {
        return this.letterSpacing;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[name=" + this.name + ",style=" + string + ",size=" + this.size + (String)(this.letterSpacing > 0 ? ",spacing:" + this.letterSpacing : "") + "]";
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public String hash() {
        if (this.hash == null) {
            this.hash = Font.hash(this.fontNames, this.style, this.size, this.letterSpacing);
        }
        return this.hash;
    }

    public static final String hash(String string, int n2, int n3) {
        return Font.hash(new String[]{string}, n2, n3, 0);
    }

    public static final String hash(String string, int n2, int n3, int n4) {
        return Font.hash(new String[]{string}, n2, n3, n4);
    }

    public static final String hash(String[] stringArray, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append('.');
        }
        stringBuilder.append(n2);
        stringBuilder.append('.');
        stringBuilder.append(n3);
        stringBuilder.append('.');
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Font) {
            Font font = (Font)object;
            bl = this.hashCode() == font.hashCode() && Equaler.verifyEquals((Object)this.hash(), (Object)font.hash());
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.hash().hashCode();
        }
        return this.hashCode;
    }

    public static String encodeFont(Font font) {
        return font.getName() + "," + font.getStyle() + "," + font.getSize() + (String)(font.letterSpacing > 0 ? "," + font.letterSpacing : "");
    }

    public static Font decodeFont(String string) {
        StringTokenizer stringTokenizer;
        Font font = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, ",", false)).countTokens() >= 3) {
            try {
                String string2 = stringTokenizer.nextToken();
                int n2 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken());
                int n3 = 0;
                int n4 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = NumberParserUtil.parseInt((String)stringTokenizer.nextToken());
                }
                font = new Font(string2, n2, n4, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return font;
    }

    public String[] getFontNames() {
        if (this.fontNames == null) {
            this.fontNames = new String[]{this.name};
        }
        return this.fontNames;
    }
}

