/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.project.resourcecache;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.SortedList;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.project.resourcecache.ProjectResource;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class PathNode
implements Serializable {
    public static final long serialVersionUID = 2751121163239L;
    private static final PathNodeComparator PATH_NODE_COMPARATOR = new PathNodeComparator();
    private static final ProjectResourceComparator RESOURCE_COMPARATOR = new ProjectResourceComparator();
    private static final _b SEARCH_RESOURCE = new _b();
    private static final PathNode SEARCH_PATH_NODE = new PathNode(null, null);
    private String name;
    private PathNode parent;
    private List<PathNode> children = new SortedList((Comparator)PATH_NODE_COMPARATOR);
    private List<ProjectResource> childrenResources = new SortedList((Comparator)RESOURCE_COMPARATOR);

    public PathNode(String string, PathNode pathNode) {
        this.name = string;
        this.parent = pathNode;
    }

    public String getName() {
        return this.name;
    }

    public PathNode getParent() {
        return this.parent;
    }

    public PathNode getChildWithName(String string) {
        PathNode.SEARCH_PATH_NODE.name = string;
        int n2 = this.children.indexOf(SEARCH_PATH_NODE);
        if (n2 >= 0) {
            return this.children.get(n2);
        }
        return null;
    }

    public PathNode createChildWithName(String string) {
        PathNode pathNode = new PathNode(string, this);
        this.children.add(pathNode);
        return pathNode;
    }

    public ProjectResource getResource(String string, String string2, String string3) {
        SEARCH_RESOURCE.b(string, string3, string2);
        int n2 = this.childrenResources.indexOf(SEARCH_RESOURCE);
        if (n2 >= 0) {
            return this.childrenResources.get(n2);
        }
        return null;
    }

    public void removeResource(ProjectResource projectResource) {
        this.childrenResources.remove(projectResource);
        projectResource.removeParent();
    }

    public Iterator<ProjectResource> getChildrenResources() {
        return this.childrenResources.iterator();
    }

    public Iterator<PathNode> getChildren() {
        return this.children.iterator();
    }

    public void addResource(ProjectResource projectResource) {
        this.childrenResources.add(projectResource);
    }

    public void removeChildNode(PathNode pathNode) {
        this.children.remove(pathNode);
        pathNode.parent = null;
    }

    public boolean isEmpty() {
        return this.children.isEmpty() && this.childrenResources.isEmpty();
    }

    public String toString() {
        return "Path node: " + this.name;
    }

    protected String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.parent != null) {
            stringBuilder.append(this.parent.getPath());
            stringBuilder.append(this.name);
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public void updateTimestamp() {
    }

    public File getFileForNode() {
        File file = null;
        try {
            file = URLUtil.getAbsoluteFileFromFileUrl((URL)new URL(this.getPath()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return file;
    }

    public boolean isFolderModified() {
        return true;
    }

    @SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
    private static class PathNodeComparator
    implements Comparator<PathNode>,
    Serializable {
        private PathNodeComparator() {
        }

        @Override
        public int compare(PathNode pathNode, PathNode pathNode2) {
            return pathNode.name.compareTo(pathNode2.name);
        }
    }

    @SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
    private static class ProjectResourceComparator
    implements Comparator<ProjectResource>,
    Serializable {
        private ProjectResourceComparator() {
        }

        @Override
        public int compare(ProjectResource projectResource, ProjectResource projectResource2) {
            int n2 = projectResource.getName().compareTo(projectResource2.getName());
            if (n2 == 0) {
                if (projectResource.getAnchor() != null && projectResource2.getAnchor() != null) {
                    n2 = projectResource.getAnchor().compareTo(projectResource2.getAnchor());
                } else if (projectResource.getAnchor() != null) {
                    n2 = 1;
                } else if (projectResource2.getAnchor() != null) {
                    n2 = -1;
                }
                if (n2 == 0) {
                    if (projectResource.getQuery() != null && projectResource2.getQuery() != null) {
                        n2 = projectResource.getQuery().compareTo(projectResource2.getQuery());
                    } else if (projectResource.getQuery() != null) {
                        n2 = 1;
                    } else if (projectResource2.getQuery() != null) {
                        n2 = -1;
                    }
                }
            }
            return n2;
        }
    }

    private static class _b
    extends ProjectResource {
        public _b() {
            super(null, null, null, null);
        }

        public void b(String string, String string2, String string3) {
            this.name = string;
            this.anchor = string3;
            this.query = string2;
        }
    }
}

