/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.plugin;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.PluginContext;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginLoadException;
import ro.sync.exml.plugin.PluginManager;

public class PluginDependencyInjector {
    private static final Logger b = LoggerFactory.getLogger((String)PluginManager.class.getName());

    private PluginDependencyInjector() {
    }

    public static void injectDependencies(Object object, PluginDescriptor pluginDescriptor) throws PluginLoadException {
        if (object == null) {
            return;
        }
        try {
            Class<?> clazz = object.getClass();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                Field field = fieldArray[i2];
                if (field.getAnnotation(PluginContext.class) == null) continue;
                PluginDependencyInjector.c(object, pluginDescriptor, field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error("Failed to inject dependency to class {}", (Object)object.getClass().getName(), (Object)noClassDefFoundError);
        }
    }

    private static void c(Object object2, PluginDescriptor pluginDescriptor, Field field) throws PluginLoadException {
        boolean bl = false;
        List<Object> list = pluginDescriptor.getContextInstances();
        String string = pluginDescriptor.getName();
        String string2 = pluginDescriptor.getBaseDir().getAbsolutePath();
        for (Object object3 : list) {
            if (!object3.getClass().isAssignableFrom(field.getType())) continue;
            boolean bl2 = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(object2, object3);
                bl = true;
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                String string3 = "Failed to load plugin. Failed to inject dependency from context for field " + field.getDeclaringClass() + "." + field.getName();
                b.error(string3, (Throwable)exception);
                throw new PluginLoadException(string, string2, string3);
            }
            finally {
                field.setAccessible(bl2);
            }
        }
        if (!bl) {
            Object object3;
            String string4 = list.stream().map(object -> object.getClass().getName()).collect(Collectors.joining(", "));
            object3 = "Could not find a context instance to initialize field " + field.getName() + " of class " + object2.getClass().getName() + ". Context instances available for classes: " + (String)string4 + ".";
            b.error((String)object3);
            throw new PluginLoadException(string, string2, (String)object3);
        }
    }
}

