/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.charsequence.CharSequenceUtil;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.exml.editor.xmleditor.transform.CancelledException;
import ro.sync.exml.editor.xmleditor.transform.ParamDescriptor;
import ro.sync.exml.editor.xmleditor.transform.ab;
import ro.sync.exml.editor.xmleditor.transform.c.e;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TransformationParameter
implements PersistentObject,
e {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TransformationParameter.class.getName());
    private ParamDescriptor paramDescription;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String name;
    @PersistentObjectField(hasEditorVariables=true)
    private String value;
    private boolean hasXPathValue;
    private boolean isStatic;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String defaultValue;
    private transient boolean detected;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String comment;
    private transient int startLine = -1;
    private transient int startColumn = -1;
    private transient int endLine = -1;
    private transient int endColumn = -1;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String systemID;
    private transient int level;
    public static StringBuilder DEBUG_BUILDER;
    public static final String PARAM_INTERNAL_SEPARATOR = "~n~";

    public TransformationParameter() {
    }

    public TransformationParameter(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public TransformationParameter(ParamDescriptor paramDescriptor, String string) {
        this.paramDescription = paramDescriptor;
        this.setValue(string);
    }

    public ParamDescriptor getParamDescription() {
        return this.paramDescription;
    }

    public String toExternalForm() {
        if (this.paramDescription != null) {
            return this.paramDescription.getClarkNotation() + PARAM_INTERNAL_SEPARATOR + this.value;
        }
        return this.name + PARAM_INTERNAL_SEPARATOR + this.value;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        if (this.paramDescription == null) {
            this.paramDescription = new ParamDescriptor(string);
        } else {
            String[] stringArray = BasicXmlUtil.detectNamespaceClark((String)string);
            this.paramDescription.setNamespace(stringArray[0]);
            this.paramDescription.setName(stringArray[1]);
        }
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public String getName() {
        return this.paramDescription.getClarkNotation();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean hasXPathValue() {
        return this.hasXPathValue;
    }

    public void setHasXPathValue(boolean bl) {
        this.hasXPathValue = bl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        Object object;
        int n2 = 100;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)iOException, (Throwable)iOException);
        }
        object = arrayList.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (string2.trim().length() == 0) {
                if (bl) {
                    object.remove();
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        for (String charSequence2 : arrayList) {
            if (charSequence2.trim().length() <= 0) continue;
            n2 = Math.min(n2, CharSequenceUtil.countWSCharsAtStart((CharSequence)charSequence2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : arrayList) {
            if (string2.trim().length() > 0) {
                stringBuffer.append(string2.substring(n2));
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append('\n');
        }
        this.comment = stringBuffer.toString();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public void setDetected(boolean bl) {
        this.detected = bl;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int n2) {
        this.endColumn = n2;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int n2) {
        this.endLine = n2;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int n2) {
        this.startColumn = n2;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int n2) {
        this.startLine = n2;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String string) {
        this.systemID = string;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n2) {
        this.level = n2;
    }

    public String toString() {
        return "XsltParameter(name: " + (this.paramDescription != null ? this.paramDescription.getClarkNotation() : null) + ", value: " + this.value + ", xpathValue: " + this.hasXPathValue + (String)(this.defaultValue == null ? "" : ", defaultValue: " + this.defaultValue) + (String)(this.comment == null ? "" : ", comment: " + this.comment) + (String)(this.systemID == null ? "" : ", systemID: " + this.systemID) + ", level: " + this.level + (String)(this.startLine == -1 ? "" : ", location(" + this.startLine + ", " + this.startColumn + ", " + this.endLine + ", " + this.endColumn) + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransformationParameter)) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("T: " + this + " O: " + object);
        }
        TransformationParameter transformationParameter = (TransformationParameter)object;
        if (!Equaler.verifyEquals((Object)transformationParameter.paramDescription.getClarkNotation(), (Object)this.paramDescription.getClarkNotation()) || !Equaler.verifyEquals((Object)transformationParameter.value, (Object)this.value)) {
            LOGGER.debug("Return false");
            return false;
        }
        LOGGER.debug("Return true");
        return true;
    }

    public int hashCode() {
        int n2 = this.paramDescription.getClarkNotation().hashCode();
        if (this.value != null) {
            n2 += this.value.hashCode();
        }
        return n2;
    }

    public static List<TransformationParameter> expandEditorVariables(List list, String string, boolean bl) throws CancelledException {
        ArrayList<TransformationParameter> arrayList = new ArrayList<TransformationParameter>();
        if (list != null) {
            for (TransformationParameter transformationParameter : list) {
                if (transformationParameter == null || transformationParameter.getName() == null || transformationParameter.getValue() == null) continue;
                String string2 = ab.p(transformationParameter.getValue().trim(), transformationParameter.getName(), string, bl, false, Collections.emptyList());
                TransformationParameter transformationParameter2 = new TransformationParameter(transformationParameter.getParamDescription(), string2);
                transformationParameter2.setHasXPathValue(transformationParameter.hasXPathValue());
                transformationParameter2.setStatic(transformationParameter.isStatic);
                arrayList.add(transformationParameter2);
            }
        }
        if (DEBUG_BUILDER != null) {
            DEBUG_BUILDER.append("Expanded to: " + arrayList);
        }
        return arrayList;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.comment != null) {
            stringBuilder.append(this.comment);
        }
        if (this.defaultValue != null) {
            stringBuilder.append("Default value:").append(this.defaultValue.indexOf(10) == -1 ? (char)' ' : '\n');
            stringBuilder.append(this.defaultValue).append('\n');
        }
        if (this.systemID != null) {
            stringBuilder.append("System ID: ").append(this.systemID).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.name != null && (this.paramDescription == null || this.paramDescription.getLocalName() == null)) {
            this.setName(this.name);
        }
        if (this.paramDescription == null) {
            throw new InvalidPersistentObjException("Invalid parameter name.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            TransformationParameter transformationParameter = (TransformationParameter)super.clone();
            if (this.paramDescription != null) {
                transformationParameter.paramDescription = (ParamDescriptor)this.paramDescription.clone();
            }
            return transformationParameter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public String getCompareKey() {
        if (this.paramDescription != null) {
            return this.paramDescription.getNamespace() == null ? this.paramDescription.getLocalName() : this.paramDescription.getLocalName() + "{" + this.paramDescription.getNamespace() + "}";
        }
        return this.getName();
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

