/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.xmleditor.transform.Scenario;
import ro.sync.exml.editor.xmleditor.transform.d;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableList;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ScenarioAssociation
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioAssociation.class);
    private String url;
    private SerializableList<String> scenarioIds = new SerializableList();
    private SerializableList<String> scenarioTypes = new SerializableList();
    private SerializableList<Byte> scenarioStorageLocations = new SerializableList();
    private List<d> cachedAssociatedScenarios = null;

    public ScenarioAssociation() {
    }

    public ScenarioAssociation(List<String> list, List<String> list2, List<Byte> list3, String string) {
        this.url = string;
        this.scenarioIds.addAll(list);
        this.scenarioTypes.addAll(list2);
        this.scenarioStorageLocations.addAll(list3);
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.scenarioIds == null || this.scenarioIds.isEmpty()) {
            throw new InvalidPersistentObjException("Invalid names in scenario association");
        }
        if (this.scenarioStorageLocations == null) {
            throw new InvalidPersistentObjException("Invalid storage locations in scenario association");
        }
        if (this.scenarioTypes == null || this.scenarioTypes.isEmpty()) {
            throw new InvalidPersistentObjException("Invalid type in scenario association");
        }
        List<String> list = Arrays.asList(Scenario.getAllScenarioTypes());
        SerializableList<String> serializableList = new SerializableList<String>(this.scenarioTypes.size());
        for (String string : this.scenarioTypes) {
            if (!("Validation_scenario".equals(string) || "Default_engine_scenario_type_1254902349626".equals(string) || list.contains(string))) {
                string = "Validation_scenario";
            }
            serializableList.add(string);
        }
        this.scenarioTypes = serializableList;
        if (this.url == null) {
            throw new InvalidPersistentObjException("Invalid url in scenario association");
        }
        int n2 = this.scenarioIds.size();
        if (n2 != this.scenarioTypes.size() || !this.scenarioStorageLocations.isEmpty() && n2 != this.scenarioStorageLocations.size()) {
            throw new InvalidPersistentObjException("The scenario names list, scenario types list and scenario locations list have a different number of entries for URL: " + this.url + " IDs count = " + n2 + " Types count = " + this.scenarioTypes.size() + " Locations count = " + this.scenarioStorageLocations.size());
        }
    }

    public List<d> getAssociatedScenariosInfo() {
        if (this.cachedAssociatedScenarios == null) {
            this.cachedAssociatedScenarios = new ArrayList<d>();
            boolean bl = !this.scenarioStorageLocations.isEmpty();
            int n2 = this.scenarioIds.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Byte by = null;
                if (bl) {
                    by = (Byte)this.scenarioStorageLocations.get(i2);
                }
                this.cachedAssociatedScenarios.add(new d((String)this.scenarioIds.get(i2), (String)this.scenarioTypes.get(i2), by));
            }
        }
        return this.cachedAssociatedScenarios;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "Scenario IDs = " + this.scenarioIds + " types = " + this.scenarioTypes + " storageLocations = " + this.scenarioStorageLocations + " url = " + this.url;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"cachedAssociatedScenarios"};
    }

    @Override
    public Object clone() {
        ScenarioAssociation scenarioAssociation = null;
        try {
            scenarioAssociation = (ScenarioAssociation)super.clone();
            if (this.scenarioIds != null) {
                scenarioAssociation.scenarioIds = (SerializableList)this.scenarioIds.clone();
            }
            if (this.scenarioTypes != null) {
                scenarioAssociation.scenarioTypes = (SerializableList)this.scenarioTypes.clone();
            }
            if (this.scenarioStorageLocations != null) {
                scenarioAssociation.scenarioStorageLocations = (SerializableList)this.scenarioStorageLocations.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return scenarioAssociation;
    }
}

