/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ParamDescriptor
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ParamDescriptor.class.getName());
    @PersistentObjectField(hasEditorVariables=false)
    private String localName;
    @PersistentObjectField(hasEditorVariables=false)
    private String prefix;
    @PersistentObjectField(hasEditorVariables=false)
    private String namespace = null;

    public String getClarkNotation() {
        return this.getNamespace() == null ? this.getLocalName() : "{" + this.getNamespace() + "}" + this.getLocalName();
    }

    public ParamDescriptor() {
    }

    public ParamDescriptor(String string, String string2, String string3) {
        this.localName = string;
        this.namespace = "".equals(string2) ? null : string2;
        this.prefix = string3;
    }

    public ParamDescriptor(String string) {
        String[] stringArray = BasicXmlUtil.detectNamespaceClark((String)string);
        this.localName = stringArray[1];
        this.namespace = stringArray[0];
        this.prefix = null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.localName == null) {
            throw new InvalidPersistentObjException("Invalid parameter descriptor");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        ParamDescriptor paramDescriptor = null;
        try {
            paramDescriptor = (ParamDescriptor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return paramDescriptor;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Name: ").append(this.localName).append(" Namespace: ");
        stringBuilder.append(this.namespace).append(" prefixu': ").append(this.prefix);
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.localName = string;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public boolean equals(Object object) {
        if (object instanceof ParamDescriptor) {
            ParamDescriptor paramDescriptor = (ParamDescriptor)object;
            return Equaler.verifyEquals((Object)this.localName, (Object)paramDescriptor.localName) && Equaler.verifyEquals((Object)this.namespace, (Object)paramDescriptor.namespace) && Equaler.verifyEquals((Object)this.prefix, (Object)paramDescriptor.prefix);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

