/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.projecteditingstate;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.finders.SASearchReferencesScopePO;
import ro.sync.exml.editor.finders.SearchReferencesScopePO;
import ro.sync.exml.editor.finders.WorkingSetPO;
import ro.sync.exml.editor.projecteditingstate.MarkLocation;
import ro.sync.exml.editor.projecteditingstate.OpenedFileInfo;
import ro.sync.exml.editor.projecteditingstate.ProfilingConditionalTextState;
import ro.sync.exml.editor.xmleditor.XMLResourcesScopePO;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableLinkedHashMap;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class State
implements PersistentObject {
    URL projectURL;
    SerializableLinkedHashMap bookMarkLocations = new SerializableLinkedHashMap(9);
    MarkLocation[] breakPointLocations = new MarkLocation[0];
    private OpenedFileInfo[] lastOpenedFiles = null;
    private OpenedFileInfo[] lastDITAOpenedFiles = null;
    private URL archiveURL;
    private String[] openFindResourcesHistory = new String[0];
    private String[] openFindResourcesExpressionsHistory = new String[0];
    private SASearchReferencesScopePO searchComponentScope;
    private XMLResourcesScopePO xpathResourcesScope;
    private XMLResourcesScopePO xmlRefactoryResourcesScope;
    private XMLResourcesScopePO applyAllDefaultQFsResourcesScope;
    private ProfilingConditionalTextState profilingConditionalTextState;
    private WorkingSetPO[] workingSets;
    private static final Logger logger = LoggerFactory.getLogger((String)State.class.getName());

    public State() {
    }

    public State(URL uRL) {
        this.projectURL = uRL;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.bookMarkLocations == null) {
            throw new InvalidPersistentObjException("The location map for the project is null.");
        }
        if (this.breakPointLocations == null) {
            throw new InvalidPersistentObjException("The location array for breakpoints is null.");
        }
    }

    public URL getProjectURL() {
        return this.projectURL;
    }

    public Map<String, MarkLocation> getBookMarkLocations() {
        return this.bookMarkLocations;
    }

    public void setLastOpenedFiles(OpenedFileInfo[] openedFileInfoArray) {
        this.lastOpenedFiles = openedFileInfoArray;
    }

    public OpenedFileInfo[] getLastOpenedFiles() {
        if (logger.isDebugEnabled()) {
            logger.debug("Get last opened files of project: " + URLUtil.filterPasswords((String)String.valueOf(this.projectURL)) + "\n" + (this.lastOpenedFiles != null ? Arrays.asList(this.lastOpenedFiles) : null));
        }
        return this.lastOpenedFiles;
    }

    public void setLastDITAOpenedFiles(OpenedFileInfo[] openedFileInfoArray) {
        this.lastDITAOpenedFiles = openedFileInfoArray;
    }

    public OpenedFileInfo[] getLastDITAOpenedFiles() {
        return this.lastDITAOpenedFiles;
    }

    public MarkLocation[] getBreakPointLocations() {
        return this.breakPointLocations;
    }

    public void addBreakPointLocations(MarkLocation[] markLocationArray) {
        ArrayList<MarkLocation> arrayList = new ArrayList<MarkLocation>(this.breakPointLocations.length + markLocationArray.length);
        arrayList.addAll(Arrays.asList(markLocationArray));
        arrayList.addAll(Arrays.asList(this.breakPointLocations));
        while (arrayList.size() > 100) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.breakPointLocations = arrayList.toArray(new MarkLocation[0]);
    }

    public void removeBreakPointLocations() {
        this.breakPointLocations = new MarkLocation[0];
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public URL getLastOpenedArchive() {
        return this.archiveURL;
    }

    public void setLastOpenedArchive(URL uRL) {
        this.archiveURL = uRL;
    }

    public void setProfilingConditionalTextState(ProfilingConditionalTextState profilingConditionalTextState) {
        this.profilingConditionalTextState = profilingConditionalTextState;
    }

    public ProfilingConditionalTextState getProfilingConditionalTextState() {
        return this.profilingConditionalTextState;
    }

    @Override
    public Object clone() {
        State state = null;
        try {
            int n2;
            state = (State)super.clone();
            if (this.breakPointLocations != null) {
                state.breakPointLocations = (MarkLocation[])this.breakPointLocations.clone();
                for (n2 = 0; n2 < state.breakPointLocations.length; ++n2) {
                    if (this.breakPointLocations[n2] == null) continue;
                    state.breakPointLocations[n2] = (MarkLocation)this.breakPointLocations[n2].clone();
                }
            }
            if (this.lastDITAOpenedFiles != null) {
                state.lastDITAOpenedFiles = (OpenedFileInfo[])this.lastDITAOpenedFiles.clone();
                for (n2 = 0; n2 < state.lastDITAOpenedFiles.length; ++n2) {
                    if (this.lastDITAOpenedFiles[n2] == null) continue;
                    state.lastDITAOpenedFiles[n2] = (OpenedFileInfo)this.lastDITAOpenedFiles[n2].clone();
                }
            }
            if (this.lastOpenedFiles != null) {
                state.lastOpenedFiles = (OpenedFileInfo[])this.lastOpenedFiles.clone();
                for (n2 = 0; n2 < state.lastOpenedFiles.length; ++n2) {
                    if (this.lastOpenedFiles[n2] == null) continue;
                    state.lastOpenedFiles[n2] = (OpenedFileInfo)this.lastOpenedFiles[n2].clone();
                }
            }
            if (this.openFindResourcesHistory != null) {
                state.openFindResourcesHistory = (String[])this.openFindResourcesHistory.clone();
            }
            if (this.openFindResourcesExpressionsHistory != null) {
                state.openFindResourcesExpressionsHistory = (String[])this.openFindResourcesExpressionsHistory.clone();
            }
            if (this.bookMarkLocations != null) {
                state.bookMarkLocations = (SerializableLinkedHashMap)this.bookMarkLocations.clone();
            }
            if (this.searchComponentScope != null) {
                state.searchComponentScope = (SASearchReferencesScopePO)this.searchComponentScope.clone();
            }
            if (this.xpathResourcesScope != null) {
                state.xpathResourcesScope = this.xpathResourcesScope.clone();
            }
            if (this.profilingConditionalTextState != null) {
                state.profilingConditionalTextState = this.profilingConditionalTextState.clone();
            }
            if (this.xmlRefactoryResourcesScope != null) {
                state.xmlRefactoryResourcesScope = this.xmlRefactoryResourcesScope.clone();
            }
            if (this.applyAllDefaultQFsResourcesScope != null) {
                state.applyAllDefaultQFsResourcesScope = this.applyAllDefaultQFsResourcesScope.clone();
            }
            if (this.workingSets != null) {
                state.workingSets = (WorkingSetPO[])this.workingSets.clone();
                for (n2 = 0; n2 < state.workingSets.length; ++n2) {
                    if (this.workingSets[n2] == null) continue;
                    state.workingSets[n2] = (WorkingSetPO)this.workingSets[n2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return state;
    }

    public SearchReferencesScopePO getSearchComponentScope() {
        return this.searchComponentScope;
    }

    public XMLResourcesScopePO getXPathResourcesScope() {
        return this.xpathResourcesScope != null ? this.xpathResourcesScope : XMLResourcesScopePO.CURRENT_FILE_SCOPE;
    }

    public XMLResourcesScopePO getXMLRefactoryResourcesScope() {
        return this.xmlRefactoryResourcesScope != null ? this.xmlRefactoryResourcesScope : XMLResourcesScopePO.PROJECT_SCOPE;
    }

    public XMLResourcesScopePO getApplyAllDefaultQFsResourcesScope() {
        return this.applyAllDefaultQFsResourcesScope != null ? this.applyAllDefaultQFsResourcesScope : XMLResourcesScopePO.PROJECT_SCOPE;
    }

    public void setSearchComponentScope(SASearchReferencesScopePO sASearchReferencesScopePO) {
        this.searchComponentScope = sASearchReferencesScopePO;
    }

    public void setOpenFindResourcesHistory(String[] stringArray) {
        this.openFindResourcesHistory = stringArray;
    }

    public String[] getOpenFindResourcesHistory() {
        return this.openFindResourcesHistory;
    }

    public void setOpenFindResourcesExpressionsHistory(String[] stringArray) {
        this.openFindResourcesExpressionsHistory = stringArray;
    }

    public String[] getOpenFindResourcesExpressionsHistory() {
        return this.openFindResourcesExpressionsHistory;
    }

    public WorkingSetPO[] getWorkingSets() {
        return this.workingSets != null ? this.workingSets : new WorkingSetPO[]{};
    }

    public void setWorkingSets(WorkingSetPO ... workingSetPOArray) {
        this.workingSets = workingSetPOArray;
    }

    public void setXPathResourcesScope(XMLResourcesScopePO xMLResourcesScopePO) {
        this.xpathResourcesScope = xMLResourcesScopePO;
    }

    public void setXMLRefactoryResourcesScope(XMLResourcesScopePO xMLResourcesScopePO) {
        this.xmlRefactoryResourcesScope = xMLResourcesScopePO;
    }

    public void setApplyAllDefaultQFsResourcesScope(XMLResourcesScopePO xMLResourcesScopePO) {
        this.applyAllDefaultQFsResourcesScope = xMLResourcesScopePO;
    }
}

