/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.finders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.editor.finders.WorkingSetEntryPO;
import ro.sync.exml.editor.finders.WorkingSetPO;
import ro.sync.exml.editor.finders.gb;
import ro.sync.exml.editor.finders.x;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableList;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XPathWorkingSetPO
implements WorkingSetPO {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XPathWorkingSetPO.class.getName());
    private SerializableList<WorkingSetEntryPO> workingSetEntries = new SerializableList();
    private String wSetName;

    public XPathWorkingSetPO() {
    }

    public XPathWorkingSetPO(String string) {
        this(string, (List<WorkingSetEntryPO>)null);
    }

    public XPathWorkingSetPO(String string, List<WorkingSetEntryPO> list) {
        this.wSetName = string;
        this.workingSetEntries = new SerializableList();
        if (list != null) {
            this.workingSetEntries.addAll(list);
            Collections.sort(this.workingSetEntries, new gb._b());
        }
    }

    public XPathWorkingSetPO(String string, WorkingSetEntryPO ... workingSetEntryPOArray) {
        this.wSetName = string;
        this.workingSetEntries = new SerializableList();
        if (workingSetEntryPOArray != null) {
            for (int i2 = 0; i2 < workingSetEntryPOArray.length; ++i2) {
                this.workingSetEntries.add(workingSetEntryPOArray[i2]);
            }
            Collections.sort(this.workingSetEntries, new gb._b());
        }
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.wSetName == null) {
            throw new InvalidPersistentObjException("Working set must have a valid, non-null name");
        }
        if (this.workingSetEntries == null) {
            throw new InvalidPersistentObjException("Working set " + this.wSetName + " must have a valid list of entries");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public List<WorkingSetEntryPO> getEntries() {
        return this.workingSetEntries;
    }

    @Override
    public List<String> getExpandedEntries(String string) {
        return this.getExpandedEntries(string, false);
    }

    @Override
    public WorkingSetEntryPO[] addEntries(WorkingSetEntryPO ... workingSetEntryPOArray) {
        ArrayList<WorkingSetEntryPO> arrayList = new ArrayList<WorkingSetEntryPO>();
        for (int i2 = 0; i2 < workingSetEntryPOArray.length; ++i2) {
            if (this.workingSetEntries.contains(workingSetEntryPOArray[i2])) continue;
            this.workingSetEntries.add(workingSetEntryPOArray[i2]);
            arrayList.add(workingSetEntryPOArray[i2]);
        }
        Collections.sort(this.workingSetEntries, new gb._b());
        return arrayList.toArray(new WorkingSetEntryPO[0]);
    }

    @Override
    public Object clone() {
        XPathWorkingSetPO xPathWorkingSetPO = null;
        try {
            xPathWorkingSetPO = (XPathWorkingSetPO)super.clone();
            if (this.workingSetEntries != null) {
                xPathWorkingSetPO.workingSetEntries = (SerializableList)this.workingSetEntries.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return xPathWorkingSetPO;
    }

    @Override
    public String getName() {
        return this.wSetName;
    }

    @Override
    public void setName(String string) {
        this.wSetName = string;
    }

    @Override
    public x getType() {
        return x.d;
    }

    public int hashCode() {
        return Objects.hash(this.wSetName, this.workingSetEntries);
    }

    public boolean equals(Object object) {
        XPathWorkingSetPO xPathWorkingSetPO;
        if (object instanceof XPathWorkingSetPO && this.wSetName.equals((xPathWorkingSetPO = (XPathWorkingSetPO)object).getName())) {
            return Equaler.verifyListEquals(this.workingSetEntries, xPathWorkingSetPO.getEntries());
        }
        return false;
    }
}

