/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.testing;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.PlatformDetector;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class TemporaryFileManager {
    private final List<File> b = new ArrayList<File>();

    public void registerFile(File file) {
        this.b.add(file);
    }

    public void deleteAllFiles() {
        for (File file : this.b) {
            FileSystemUtil.deleteRecursivelly((File)file);
        }
    }

    public File createTemporaryFile(String string, String object) throws IOException {
        Preconditions.checkArgument((!new File((String)object).isAbsolute() ? 1 : 0) != 0);
        if (PlatformDetector.isLinux()) {
            object = "/tmp/" + (String)object;
        }
        File file = new File((String)object);
        file.createNewFile();
        this.registerFile(file);
        try (PrintWriter printWriter = new PrintWriter(file);){
            ((Writer)printWriter).write(string);
        }
        return file;
    }

    public File createTemporaryDirectory(String string) {
        File file = new File(string);
        file.mkdirs();
        this.registerFile(file);
        return file;
    }
}

