/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginManager;

@SkipObfuscate
public class WebappPluginStaticResources
extends HttpServlet {
    private static final int BAD_REQUEST_400 = 400;
    private static final Logger logger = LoggerFactory.getLogger((String)WebappPluginStaticResources.class.getName());
    private Map<String, File> staticResourcesFolders;
    private HashMap<String, String> resourcesContentSecurityPolicies;

    public void init() throws ServletException {
        super.init();
        this.staticResourcesFolders = new HashMap<String, File>();
        this.resourcesContentSecurityPolicies = new HashMap();
        PluginManager pluginManager = PluginManager.getInstance();
        List<PluginDescriptor> list = pluginManager.getPluginDescriptors();
        for (PluginDescriptor pluginDescriptor : list) {
            File file = pluginDescriptor.getBaseDir();
            List<PluginDescriptor.PluginExtensionDescription> list2 = pluginDescriptor.getExtensions("WebappStaticResourcesFolder");
            for (PluginDescriptor.PluginExtensionDescription pluginExtensionDescription : list2) {
                String string = WebappPluginStaticResources.trimSlasheshFromPath(pluginExtensionDescription.i);
                this.staticResourcesFolders.put(string, new File(file, WebappPluginStaticResources.trimSlasheshFromPath(pluginExtensionDescription.e)));
                this.resourcesContentSecurityPolicies.put(string, pluginExtensionDescription.l);
            }
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.staticResourcesFolders::size;
        logger.debug("Registered {} static resource folders providing plugins.", supplierArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        String string2 = WebappPluginStaticResources.adjustPath(string);
        File file = this.staticResourcesFolders.get(string2);
        String string3 = WebappPluginStaticResources.getResourcePath(string);
        if (file != null) {
            if (string3 != null && !string3.trim().isEmpty()) {
                File file2 = new File(file, string3);
                if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                    WebappPluginStaticResources.setContentHeaders(httpServletResponse, file2);
                    String string4 = this.resourcesContentSecurityPolicies.get(string2);
                    if (string4 != null) {
                        httpServletResponse.setHeader("Content-Security-Policy", string4);
                    }
                    try (FileInputStream fileInputStream = null;){
                        fileInputStream = new FileInputStream(file2);
                        IOUtils.copy((InputStream)fileInputStream, (OutputStream)httpServletResponse.getOutputStream());
                    }
                } else {
                    logger.error("Trying to access resource outside the resource folder.");
                    httpServletResponse.sendError(400);
                }
            } else {
                logger.warn("no resource path has been specified for the plugin {}", (Object)string2);
                httpServletResponse.sendError(400);
            }
        } else {
            httpServletResponse.setStatus(400);
            logger.warn("No plugin defined for path :{}", (Object)string2);
        }
    }

    private static void setContentHeaders(HttpServletResponse httpServletResponse, File file) {
        if (file.getName().endsWith(".css")) {
            httpServletResponse.addHeader("Content-Type", "text/css");
        } else if (file.getName().endsWith(".js")) {
            httpServletResponse.addHeader("Content-Type", "application/javascript");
        } else if (file.getName().endsWith(".svg")) {
            httpServletResponse.addHeader("Content-Type", "image/svg+xml");
        } else if (file.getName().endsWith(".png")) {
            httpServletResponse.addHeader("Content-Type", "image/png");
        } else if (file.getName().endsWith(".jpe") || file.getName().endsWith(".jpeg") || file.getName().endsWith(".jpg")) {
            httpServletResponse.addHeader("Content-Type", "image/jpeg");
        } else if (file.getName().endsWith(".gif")) {
            httpServletResponse.addHeader("Content-Type", "image/gif");
        } else if (file.getName().endsWith(".tif")) {
            httpServletResponse.addHeader("Content-Type", "image/tiff");
        } else if (file.getName().endsWith(".bmp")) {
            httpServletResponse.addHeader("Content-Type", "image/bmp");
        } else if (file.getName().endsWith(".html")) {
            httpServletResponse.addHeader("Content-Type", "text/html");
        }
        httpServletResponse.addHeader("Content-Security-Policy", "default-src: 'self';");
    }

    private static String trimSlasheshFromPath(String string) {
        if (!string.isEmpty() && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String adjustPath(String string) {
        if (string != null && !string.isEmpty()) {
            string = string.charAt(0) == '/' ? string.substring(1) : string;
            string = string.split("/")[0].trim();
        }
        return string;
    }

    private static String getResourcePath(String string) {
        int n2;
        String string2 = null;
        if (string != null && !string.isEmpty() && (n2 = (string = string.charAt(0) == '/' ? string.substring(1) : string).indexOf(47)) != -1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }
}

