/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.util.Resource;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class BuildNumberProvider {
    private static final Logger b = LoggerFactory.getLogger(BuildNumberProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWebAuthorBuildNumber() {
        String string = null;
        InputStream inputStream = null;
        try {
            inputStream = this.readManifestMf();
            if (inputStream != null) {
                Manifest manifest = new Manifest(inputStream);
                Attributes attributes = manifest.getMainAttributes();
                string = attributes.getValue("Build-Number");
            }
        }
        catch (IOException iOException) {
            b.warn((Object)iOException, (Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
        return string != null ? string : "";
    }

    protected InputStream readManifestMf() {
        URL uRL = null;
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements() && !(uRL = enumeration.nextElement()).toExternalForm().contains("WEB-INF/classes/META-INF/")) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getOxygenJarBuildNumber() {
        return Resource.getBuildNumber();
    }
}

