/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.images.xmlimages;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.contentcompletion.xml.mb;
import ro.sync.ecss.images.xmlimages.XMLFragmentEditor;
import ro.sync.exml.v;
import ro.sync.exml.workspace.api.images.handlers.CannotEditException;
import ro.sync.exml.workspace.api.images.handlers.XMLImageHandler;
import ro.sync.exml.workspace.api.images.handlers.providers.EmbeddedImageContentProvider;
import ro.sync.xml.encoding.EncodingDetector;

public abstract class AbstractXMLImageHandler
extends XMLImageHandler {
    private static final Logger j = LoggerFactory.getLogger((String)AbstractXMLImageHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean editImage(URL uRL) throws CannotEditException {
        boolean bl = false;
        if (!"file".equals(uRL.getProtocol())) throw new CannotEditException("Only local files can be edited. Could not open: " + uRL);
        ArrayList arrayList = new ArrayList(4);
        try {
            Object object;
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = EncodingDetector.getInstance().createReader(uRL, v.getInstance().getEncodingChooser(), "UTF8", arrayList);
            try {
                string = inputStreamReader.getEncoding();
                object = new char[1024];
                int n2 = inputStreamReader.read((char[])object);
                while (n2 >= 0) {
                    stringBuilder.append(new String((char[])object, 0, n2));
                    n2 = inputStreamReader.read((char[])object);
                }
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    j.debug("Could not close reader.", (Throwable)iOException);
                }
            }
            object = this.editImage(new EmbeddedImageContentProvider(uRL, stringBuilder.toString(), null));
            if (object == null) return bl;
            String string2 = "UTF-8";
            if (((String)object).startsWith("<?xml")) {
                string = EncodingDetector.getInstance().getJavaEncodingFromHeader((String)object, arrayList);
            } else if (((String)object).startsWith("<")) {
                string = "UTF8";
            }
            string2 = EncodingDetector.getInstance().getIANAEncodingFromJava(string);
            if (string2 == null) {
                throw new CannotEditException("The IANA encoding: " + string + " cannot be mapped to a Java encoding.");
            }
            try (OutputStream outputStream = AbstractXMLImageHandler.e(uRL);
                 OutputStreamWriter outputStreamWriter = EncodingDetector.getInstance().createWriter(outputStream, string, "UTF8", arrayList.size() > 2);){
                if (!((String)object).startsWith("<?xml") && string != null && string.length() > 0) {
                    outputStreamWriter.write("<?xml version='1.0' encoding='" + string2 + "'?>" + System.getProperty("line.separator"));
                }
                outputStreamWriter.write((String)object);
                return true;
            }
        }
        catch (IOException iOException) {
            j.error((Object)iOException, (Throwable)iOException);
            throw new CannotEditException(iOException.getMessage(), iOException);
        }
    }

    private static OutputStream e(URL uRL) throws IOException {
        OutputStream outputStream = null;
        if (PlatformDetector.isEclipse() && "file".equals(uRL.getProtocol())) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            outputStream = new FileOutputStream(file);
        } else {
            outputStream = URLUtil.openOutputStream((URL)uRL);
        }
        return outputStream;
    }

    @Override
    public String editImage(EmbeddedImageContentProvider embeddedImageContentProvider) throws CannotEditException {
        v v2 = v.getInstance();
        if (v2 != null) {
            XMLFragmentEditor xMLFragmentEditor = v2.getXMLFragmentEditor();
            if (xMLFragmentEditor != null) {
                return xMLFragmentEditor.editFragment(embeddedImageContentProvider.getImageSerializedContent(), embeddedImageContentProvider.getDoctype(), embeddedImageContentProvider.getUrl(), this.f());
            }
            throw new CannotEditException("The basic XML fragment editor has not been set:" + embeddedImageContentProvider.getUrl());
        }
        throw new CannotEditException("The IDE Access is null:" + embeddedImageContentProvider.getUrl());
    }

    protected abstract mb f();
}

