/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.imagemap.teip5;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.imagemap.IOriginalArea;
import ro.sync.ecss.imagemap.Shape;
import ro.sync.ecss.imagemap.b.c;
import ro.sync.ecss.imagemap.teip5.Graphic;

public class Zone
implements IOriginalArea {
    public static final String ZONE_ID = "ID";
    @XmlAttribute(name="id", namespace="http://www.w3.org/XML/1998/namespace")
    public String id;
    @XmlAttribute(name="lry")
    @XmlJavaTypeAdapter(value=c.class)
    private Float lry;
    @XmlAttribute(name="lrx")
    @XmlJavaTypeAdapter(value=c.class)
    private Float lrx;
    @XmlAttribute(name="uly")
    @XmlJavaTypeAdapter(value=c.class)
    private Float uly;
    @XmlAttribute(name="ulx")
    @XmlJavaTypeAdapter(value=c.class)
    private Float ulx;
    @XmlAttribute(name="points")
    private String points;
    @XmlElement(name="graphic", namespace="http://www.tei-c.org/ns/1.0")
    private Graphic graphic;
    @XmlTransient
    Shape shape;
    @XmlTransient
    private Integer[] coordinates;
    @XmlAnyElement
    public Element[] otherElements;
    @XmlAnyAttribute
    public Map<QName, Object> otherAttributes;

    @XmlTransient
    public boolean isEditable() {
        return this.graphic == null;
    }

    @XmlTransient
    public Integer[] getCoordinates() {
        if (this.coordinates == null) {
            if (this.points != null && this.points.trim().length() != 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                StringTokenizer stringTokenizer = new StringTokenizer(this.points, " ", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",", false);
                    if (stringTokenizer2.countTokens() == 2) {
                        while (stringTokenizer2.hasMoreTokens()) {
                            try {
                                arrayList.add(Math.round(NumberParserUtil.parseFloat((String)stringTokenizer2.nextToken())));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        continue;
                    }
                    arrayList.clear();
                    break;
                }
                if (!arrayList.isEmpty() && arrayList.size() % 2 == 0) {
                    this.coordinates = arrayList.toArray(new Integer[0]);
                    this.shape = Shape.POLY;
                }
            } else if (this.ulx != null && this.uly != null && this.lrx != null && this.lry != null) {
                this.coordinates = new Integer[4];
                this.coordinates[0] = Math.round(this.ulx.floatValue());
                this.coordinates[1] = Math.round(this.uly.floatValue());
                this.coordinates[2] = Math.round(this.lrx.floatValue()) - Math.round(this.ulx.floatValue());
                this.coordinates[3] = Math.round(this.lry.floatValue()) - Math.round(this.uly.floatValue());
                this.shape = Shape.RECT;
            }
        }
        return this.coordinates;
    }

    public void setCoordinates(Integer[] integerArray) {
        if (this.shape == Shape.RECT && integerArray.length == 4) {
            this.ulx = NumberParserUtil.valueOfFloat((float)integerArray[0].intValue());
            this.uly = NumberParserUtil.valueOfFloat((float)integerArray[1].intValue());
            this.lrx = Float.valueOf(NumberParserUtil.valueOfFloat((float)integerArray[2].intValue()).floatValue() + this.ulx.floatValue());
            this.lry = Float.valueOf(NumberParserUtil.valueOfFloat((float)integerArray[3].intValue()).floatValue() + this.uly.floatValue());
        } else {
            Boolean bl = null;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < integerArray.length; ++i2) {
                if (bl != null) {
                    if (bl.booleanValue()) {
                        stringBuilder.append(",");
                        bl = Boolean.FALSE;
                    } else {
                        stringBuilder.append(" ");
                        bl = Boolean.TRUE;
                    }
                } else {
                    bl = Boolean.TRUE;
                }
                stringBuilder.append(integerArray[i2]);
            }
            this.points = stringBuilder.toString();
        }
        this.coordinates = integerArray;
    }

    @XmlTransient
    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.points == null || this.points.trim().length() == 0 ? Shape.RECT : Shape.POLY;
        }
        return this.shape;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Shape shape = this.getShape();
        stringBuilder.append("Zone(").append((Object)shape).append(") [");
        Integer[] integerArray = this.getCoordinates();
        boolean bl = true;
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            stringBuilder.append(bl ? "" : ", ");
            stringBuilder.append(integerArray[i2]);
            bl = false;
        }
        return stringBuilder.append("]").toString();
    }

    @Override
    public boolean hasImposedLayer() {
        return false;
    }

    @Override
    @XmlTransient
    public int getImposedLayer() {
        return 0;
    }

    @Override
    public void setImposedLayer(int n2) {
    }
}

