/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.imagemap.dita;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import ro.sync.basic.classloader.ClassLoaderUtil;
import ro.sync.ecss.imagemap.IImageMap;
import ro.sync.ecss.imagemap.NamespaceMapper;
import ro.sync.ecss.imagemap.Shape;
import ro.sync.ecss.imagemap.b;
import ro.sync.ecss.imagemap.dita.Area;
import ro.sync.ecss.imagemap.dita.Image;
import ro.sync.ecss.imagemap.dita.Scope;
import ro.sync.ecss.imagemap.dita.Type;
import ro.sync.ecss.imagemap.dita.XRef;

@XmlRootElement(name="imagemap")
public class ImageMap
implements IImageMap {
    public static final String TARGET_HREF = "href";
    public static final String TARGET_KEYREF = "keyref";
    public static final String TYPE = "type";
    public static final String FORMAT = "format";
    public static final String SCOPE = "scope";
    public static final String DESCRIPTION = "description";
    @XmlElement(name="image")
    public Image image;
    @XmlElement(name="area")
    public List<Area> areas;
    @XmlAttribute(name="id")
    public String id;
    @XmlAnyElement
    public Element[] otherElements;
    @XmlAnyAttribute
    public Map<QName, Object> otherAttributes;
    private Map<String, String> uri2PrefixMappings;

    @Override
    public void removeAreas(List<b> list) {
        if (this.areas != null) {
            for (b b2 : list) {
                this.areas.remove(b2.e());
            }
        }
    }

    @Override
    public void saveAreas(List<b> list) {
        for (b b2 : list) {
            Area area = (Area)b2.e();
            if (area == null) {
                area = new Area();
                if (this.areas == null) {
                    this.areas = new ArrayList<Area>();
                }
                area.shape = b2.b();
            }
            this.areas.add(area);
            area.setCoordinates(b2.o());
            if (b2.f()) continue;
            if (area.xRef == null) {
                area.xRef = new XRef();
            }
            area.xRef.href = (String)b2.g().get(TARGET_HREF);
            area.xRef.keyref = (String)b2.g().get(TARGET_KEYREF);
            area.xRef.format = (String)b2.g().get(FORMAT);
            area.xRef.type = (Type)((Object)b2.g().get(TYPE));
            area.xRef.scope = (Scope)((Object)b2.g().get(SCOPE));
            area.xRef.setDescription((String)b2.g().get(DESCRIPTION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] serialize() throws JAXBException {
        ClassLoader classLoader = ClassLoaderUtil.installContextClassLoader((String[])new String[]{"META-INF/services/javax.xml.transform.TransformerFactory"}, (String[])new String[]{"net.sf.saxon.TransformerFactoryImpl"});
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ImageMap.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)this, (ContentHandler)((Object)new NamespaceMapper(stringWriter, this.uri2PrefixMappings)));
            String[] stringArray = new String[]{stringWriter.toString()};
            return stringArray;
        }
        finally {
            ClassLoaderUtil.uninstallContextClassLoader((ClassLoader)classLoader);
        }
    }

    @Override
    public void setURI2PrefixMappings(Map<String, String> map) {
        this.uri2PrefixMappings = map;
    }

    @Override
    public List<Shape> getAllowedShapes() {
        return new ArrayList<Shape>(Arrays.asList(Shape.RECT, Shape.CIRCLE, Shape.POLY));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ImageMap");
        if (this.id != null && !this.id.trim().isEmpty()) {
            stringBuilder.append(" id=\"").append(this.id).append("\"");
        }
        stringBuilder.append(".\n");
        stringBuilder.append(this.image);
        if (this.areas != null) {
            for (Area area : this.areas) {
                stringBuilder.append('\n').append(area);
            }
        }
        return stringBuilder.toString();
    }
}

