/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.imagemap;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.imagemap.SupportedFrameworks;
import ro.sync.util.Resource;
import ro.sync.xml.transformer.TransformerBundle;
import ro.sync.xml.transformer.c;

@SkipObfuscate
public class Areas2SVGUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)Areas2SVGUtil.class.getName());

    private Areas2SVGUtil() {
    }

    public static String fromSVG(String string, SupportedFrameworks supportedFrameworks) {
        try {
            String string2 = null;
            switch (supportedFrameworks) {
                case DITA: {
                    string2 = "/builtin/imagemap/dita/svg2imagMap.xsl";
                }
            }
            if (string2 != null) {
                TransformerBundle transformerBundle = c.vb(new StreamSource(Resource.getResourceAsStream(string2), Resource.getResource(string2).toString()), "Saxon-HE", null, null);
                Transformer transformer = transformerBundle.getTransformer();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(byteArrayOutputStream));
                try {
                    return byteArrayOutputStream.toString("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return byteArrayOutputStream.toString();
                }
            }
        }
        catch (TransformerException transformerException) {
            logger.warn((Object)transformerException, (Throwable)transformerException);
        }
        return null;
    }
}

