/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class HTMLTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private static final String ELEMENT_NAME_COLGROUP = "colgroup";
    private static final String ELEMENT_NAME_COL = "col";
    private static final String ELEMENT_NAME_THEAD = "thead";
    private static final String ELEMENT_NAME_TFOOT = "tfoot";
    private static final String ELEMENT_NAME_TBODY = "tbody";
    public static final String ATTR_NAME_SPAN = "span";
    private static final String ATTR_NAME_WIDTH = "width";
    private static final String ATTR_NAME_ALIGN = "align";
    private static final String HTML_CELL_NAME = "td";
    private static final String HTML_ROW_NAME = "tr";
    private static final String HTML_HEADER_CELL_NAME = "th";
    private static final Logger logger = LoggerFactory.getLogger((String)HTMLTableCellInfoProvider.class.getName());
    private List<WidthRepresentation> colWidthSpecs = new ArrayList<WidthRepresentation>();
    private Map<WidthRepresentation, AuthorElement> widthRepresentationsToElementsMap = new HashMap<WidthRepresentation, AuthorElement>();
    private AuthorElement tableElement;

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2;
        block3: {
            n2 = null;
            AttrValue attrValue = authorElement.getAttribute("colspan");
            if (attrValue != null) {
                try {
                    int n3 = NumberParserUtil.parseInt((String)attrValue.getValue());
                    n2 = Math.max(n3, 1);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.errorsListener == null) break block3;
                    this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), "colspan");
                }
            }
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2;
        block3: {
            n2 = null;
            AttrValue attrValue = authorElement.getAttribute("rowspan");
            if (attrValue != null) {
                try {
                    int n3 = NumberParserUtil.parseInt((String)attrValue.getValue());
                    n2 = Math.max(n3, 1);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.errorsListener == null) break block3;
                    this.errorsListener.add(authorElement, this.tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), "rowspan");
                }
            }
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
        block27: {
            block26: {
                this.tableElement = authorElement;
                AuthorElement[] authorElementArray = HTMLTableCellInfoProvider.getElementsByLocalName(authorElement, ELEMENT_NAME_COLGROUP);
                if (authorElementArray == null || authorElementArray.length <= 0) break block26;
                for (int i2 = 0; i2 < authorElementArray.length; ++i2) {
                    int n2;
                    AttrValue attrValue;
                    AuthorElement authorElement2;
                    block23: {
                        authorElement2 = authorElementArray[i2];
                        attrValue = authorElement2.getAttribute(ATTR_NAME_SPAN);
                        n2 = 1;
                        if (attrValue != null) {
                            try {
                                n2 = NumberParserUtil.parseInt((String)attrValue.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
                                if (this.errorsListener == null) break block23;
                                this.errorsListener.add(authorElement2, authorElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), ATTR_NAME_SPAN);
                            }
                        }
                    }
                    attrValue = authorElement2.getAttribute(ATTR_NAME_WIDTH);
                    String string = null;
                    if (attrValue != null) {
                        string = attrValue.getValue();
                    }
                    String string2 = null;
                    attrValue = authorElement2.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue != null) {
                        string2 = attrValue.getValue();
                    }
                    List<AuthorNode> list = authorElement2.getContentNodes();
                    for (AuthorNode n4 : list) {
                        int n3;
                        String string3;
                        String string4;
                        AuthorElement numberFormatException;
                        block24: {
                            if (!(n4 instanceof AuthorElement) || !ELEMENT_NAME_COL.equalsIgnoreCase((numberFormatException = (AuthorElement)n4).getLocalName())) continue;
                            n2 = -1;
                            AttrValue attrValue2 = numberFormatException.getAttribute(ATTR_NAME_WIDTH);
                            string4 = null;
                            if (attrValue2 != null) {
                                string4 = attrValue2.getValue();
                            } else if (string != null) {
                                string4 = string;
                            }
                            string3 = string2;
                            attrValue = numberFormatException.getAttribute(ATTR_NAME_ALIGN);
                            if (attrValue != null) {
                                string3 = attrValue.getValue();
                            }
                            AttrValue attrValue3 = numberFormatException.getAttribute(ATTR_NAME_SPAN);
                            n3 = 1;
                            if (attrValue3 != null) {
                                try {
                                    n3 = NumberParserUtil.parseInt((String)attrValue3.getValue());
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    logger.debug((Object)numberFormatException2, (Throwable)numberFormatException2);
                                    if (this.errorsListener == null) break block24;
                                    this.errorsListener.add(numberFormatException, authorElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, ATTR_NAME_SPAN, attrValue3.getValue());
                                }
                            }
                        }
                        for (int i3 = 0; i3 < n3; ++i3) {
                            WidthRepresentation widthRepresentation = new WidthRepresentation(string4, true);
                            widthRepresentation.setAlign(string3);
                            this.colWidthSpecs.add(widthRepresentation);
                            this.widthRepresentationsToElementsMap.put(widthRepresentation, numberFormatException);
                        }
                    }
                    if (n2 <= 0) continue;
                    for (int i4 = 0; i4 < n2; ++i4) {
                        WidthRepresentation widthRepresentation = new WidthRepresentation(string, true);
                        widthRepresentation.setAlign(string2);
                        this.colWidthSpecs.add(widthRepresentation);
                    }
                }
                break block27;
            }
            AuthorElement[] authorElementArray = HTMLTableCellInfoProvider.getElementsByLocalName(authorElement, ELEMENT_NAME_COL);
            if (authorElementArray == null || authorElementArray.length <= 0) break block27;
            for (int i5 = 0; i5 < authorElementArray.length; ++i5) {
                int n4;
                String string;
                String string5;
                AuthorElement authorElement4;
                block25: {
                    authorElement4 = authorElementArray[i5];
                    AttrValue attrValue = authorElement4.getAttribute(ATTR_NAME_WIDTH);
                    string5 = null;
                    if (attrValue != null) {
                        string5 = attrValue.getValue();
                    }
                    string = null;
                    AttrValue attrValue4 = authorElement4.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue4 != null) {
                        string = attrValue4.getValue();
                    }
                    AttrValue attrValue5 = authorElement4.getAttribute(ATTR_NAME_SPAN);
                    n4 = 1;
                    if (attrValue5 != null) {
                        try {
                            n4 = NumberParserUtil.parseInt((String)attrValue5.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
                            if (this.errorsListener == null) break block25;
                            this.errorsListener.add(authorElement4, authorElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, ATTR_NAME_SPAN, attrValue5.getValue());
                        }
                    }
                }
                for (int i4 = 0; i4 < n4; ++i4) {
                    WidthRepresentation widthRepresentation = new WidthRepresentation(string5, true);
                    widthRepresentation.setAlign(string);
                    this.colWidthSpecs.add(widthRepresentation);
                    this.widthRepresentationsToElementsMap.put(widthRepresentation, authorElement4);
                }
            }
        }
    }

    private static AuthorElement[] getElementsByLocalName(AuthorElement authorElement, String string) {
        AuthorElement[] authorElementArray = null;
        authorElementArray = authorElement.getLocalName().equals(authorElement.getLocalName().toUpperCase()) ? authorElement.getElementsByLocalName(string.toUpperCase()) : authorElement.getElementsByLocalName(string);
        return authorElementArray;
    }

    @Override
    public String getDescription() {
        return "Provides information about cells in HTML tables";
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        return true;
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        ArrayList<WidthRepresentation> arrayList = null;
        int n4 = this.colWidthSpecs.size();
        if (n4 >= n2 && n4 >= n2 + n3) {
            arrayList = new ArrayList<WidthRepresentation>(n3);
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                arrayList.add(this.colWidthSpecs.get(i2));
            }
        }
        return arrayList;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(string)) {
            int n2;
            int n3;
            AuthorElement[] authorElementArray = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_COLGROUP);
            boolean bl = false;
            if (authorElementArray != null && authorElementArray.length > 0) {
                bl = true;
                n3 = 0;
                for (n2 = 0; n2 < authorElementArray.length; ++n2) {
                    AuthorElement authorElement = authorElementArray[n2];
                    AuthorElement[] authorElementArray2 = HTMLTableCellInfoProvider.getElementsByLocalName(authorElement, ELEMENT_NAME_COL);
                    for (int i2 = 0; i2 < authorElementArray2.length; ++i2) {
                        int n4;
                        AuthorElement authorElement2 = authorElementArray2[i2];
                        if ((n4 = n3++) >= widthRepresentationArray.length) continue;
                        WidthRepresentation widthRepresentation = widthRepresentationArray[n4];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(widthRepresentation.getWidthRepresentation()), authorElement2);
                    }
                }
            } else {
                AuthorElement[] authorElementArray3 = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_COL);
                if (authorElementArray3 != null && authorElementArray3.length > 0) {
                    bl = true;
                    for (n2 = 0; n2 < authorElementArray3.length; ++n2) {
                        AuthorElement authorElement = authorElementArray3[n2];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(widthRepresentationArray[n2].getWidthRepresentation()), authorElement);
                    }
                }
            }
            if (!bl && widthRepresentationArray != null && authorDocumentController != null) {
                n3 = this.getInsertColsOffset();
                if (n3 == -1) {
                    throw new AuthorOperationException("No valid offset to insert the columns width specification.");
                }
                String string2 = this.createXMLFragment(widthRepresentationArray);
                authorDocumentController.insertXMLFragment(string2, n3);
            }
        }
    }

    private int getInsertColsOffset() {
        int n2 = -1;
        AuthorElement[] authorElementArray = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_THEAD);
        if (authorElementArray != null && authorElementArray.length > 0) {
            n2 = authorElementArray[0].getStartOffset();
        } else {
            AuthorElement[] authorElementArray2 = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_TBODY);
            if (authorElementArray2 != null && authorElementArray2.length > 0) {
                n2 = authorElementArray2[0].getStartOffset();
            } else {
                AuthorElement[] authorElementArray3 = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, HTML_ROW_NAME);
                if (authorElementArray3 != null && authorElementArray3.length > 0) {
                    n2 = authorElementArray3[0].getStartOffset();
                } else {
                    AuthorElement[] authorElementArray4 = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_TFOOT);
                    if (authorElementArray4 != null && authorElementArray4.length > 0) {
                        n2 = authorElementArray4[0].getStartOffset();
                    }
                }
            }
        }
        return n2;
    }

    private String createXMLFragment(WidthRepresentation[] widthRepresentationArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.tableElement.getNamespace();
        for (int i2 = 0; i2 < widthRepresentationArray.length; ++i2) {
            WidthRepresentation widthRepresentation = widthRepresentationArray[i2];
            stringBuilder.append("<col");
            String string2 = widthRepresentation.getWidthRepresentation();
            if (string2 != null) {
                stringBuilder.append(" width=\"" + widthRepresentation.getWidthRepresentation() + "\"");
            }
            if (string != null && string.length() > 0) {
                stringBuilder.append(" xmlns=\"" + string + "\"");
            }
            stringBuilder.append("/>");
        }
        return stringBuilder.toString();
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(string) && n2 > 0 && authorDocumentController != null) {
            if (this.tableElement != null) {
                String string2 = String.valueOf(n2);
                authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(string2), this.tableElement);
            } else {
                throw new AuthorOperationException("Cannot find the element representing the table.");
            }
        }
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        WidthRepresentation widthRepresentation = null;
        if (this.isHTMLTableCellTagName(string)) {
            widthRepresentation = this.getTableWidth();
        }
        return widthRepresentation;
    }

    private WidthRepresentation getTableWidth() {
        String string;
        AttrValue attrValue;
        WidthRepresentation widthRepresentation = null;
        if (this.tableElement != null && (attrValue = this.tableElement.getAttribute(ATTR_NAME_WIDTH)) != null && (string = attrValue.getValue()) != null) {
            widthRepresentation = new WidthRepresentation(string, true);
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    public boolean isHTMLTableCellTagName(String string) {
        return HTML_CELL_NAME.equalsIgnoreCase(string) || HTML_HEADER_CELL_NAME.equalsIgnoreCase(string);
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        return this.colWidthSpecs.isEmpty() ? null : this.colWidthSpecs;
    }

    public AuthorElement getColSpec(int n2) {
        if (this.colWidthSpecs != null && this.colWidthSpecs.size() > n2) {
            return this.widthRepresentationsToElementsMap.get(this.colWidthSpecs.get(n2));
        }
        return null;
    }

    @Override
    public boolean isPreferPercentageColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }
}

