/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLConstants;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements XHTMLConstants {
    public DeleteColumnOperation() {
        super(new XHTMLDocumentTypeHelper());
    }

    @Override
    public void updateColspec(AuthorAccess authorAccess, Integer n2) {
        AuthorElement authorElement;
        HTMLTableCellInfoProvider hTMLTableCellInfoProvider = (HTMLTableCellInfoProvider)this.tableHelper.getTableCellSpanProvider(this.tableElem);
        if (n2 >= 0 && (authorElement = hTMLTableCellInfoProvider.getColSpec(n2)) != null) {
            int n3 = authorAccess.getEditorAccess().getCaretOffset() - (authorElement.getEndOffset() - authorElement.getStartOffset() + 1);
            boolean bl = false;
            AttrValue attrValue = authorElement.getAttribute("span");
            if (attrValue != null && attrValue.getValue() != null) {
                try {
                    int n4 = NumberParserUtil.parseInt((String)attrValue.getValue());
                    if (n4 > 2) {
                        authorAccess.getDocumentController().setAttribute("span", new AttrValue("" + (n4 - 1)), authorElement);
                        bl = true;
                    } else if (n4 == 2) {
                        authorAccess.getDocumentController().removeAttribute("span", authorElement);
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl) {
                authorAccess.getDocumentController().deleteNode(authorElement);
            }
            authorAccess.getEditorAccess().setCaretPosition(n3);
        }
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) throws AuthorOperationException {
        this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, n3 - 1);
    }
}

