/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements CALSConstants,
InsertTableCellsContentConstants {
    private ArgumentDescriptor[] arguments;
    protected String cellContent;

    public InsertColumnOperation() {
        this(new CALSDocumentTypeHelper());
    }

    public InsertColumnOperation(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
        ArgumentDescriptor[] argumentDescriptorArray = super.getArguments();
        if (argumentDescriptorArray != null) {
            this.arguments = new ArgumentDescriptor[argumentDescriptorArray.length + 1];
            for (int i2 = 0; i2 < argumentDescriptorArray.length; ++i2) {
                this.arguments[i2] = argumentDescriptorArray[i2];
            }
            this.arguments[argumentDescriptorArray.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            this.arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue("cellFragment");
        if (object instanceof String) {
            this.cellContent = (String)object;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperationInternal(authorAccess, argumentsMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, TableColumnSpecificationInformation tableColumnSpecificationInformation, String string, int n3) throws AuthorOperationException {
        void var19_34;
        Collection<AuthorNode> collection;
        Set<CALSColSpec> set = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getColSpecs();
        int n4 = -1;
        WidthRepresentation widthRepresentation = null;
        boolean bl = false;
        boolean bl2 = set.isEmpty();
        boolean bl3 = set.isEmpty();
        boolean bl4 = set.isEmpty();
        for (CALSColSpec object22 : set) {
            if (object22.getColumnName() != null && !bl4) {
                bl4 = true;
            }
            if (object22.isColNumberSpecified() && !bl3) {
                bl3 = true;
            }
            if (object22.getColWidth() == null || bl2) continue;
            bl2 = true;
        }
        for (CALSColSpec cALSColSpec : set) {
            n4 = cALSColSpec.getIndexInDocument();
            if (cALSColSpec.getColumnNumber() >= n2 + 1) {
                bl = true;
                break;
            }
            widthRepresentation = cALSColSpec.getColWidth();
        }
        int n5 = -1;
        String string2 = "colspec";
        if (n4 != -1) {
            collection = authorElement.getContentNodes();
            for (AuthorNode authorNode : collection) {
                if (!this.tableHelper.isColspec(authorNode)) continue;
                String string3 = ((AuthorElement)authorNode).getLocalName();
                AttrValue attrValue = ((AuthorElement)authorNode).getAttribute("colnum");
                if (attrValue == null) continue;
                try {
                    int n6 = NumberParserUtil.parseInt((String)attrValue.getValue());
                    if (n6 < n2 + 1) continue;
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (n6 + n3)), (AuthorElement)authorNode);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int n7 = 0;
            for (AuthorNode authorNode : collection) {
                if (!this.tableHelper.isColspec(authorNode)) continue;
                String string4 = ((AuthorElement)authorNode).getLocalName();
                if (n7 == n4) {
                    n5 = bl ? authorNode.getStartOffset() : authorNode.getEndOffset() + 1;
                    break;
                }
                ++n7;
            }
        } else if (n2 == 0) {
            n5 = authorElement.getStartOffset() + 1;
        }
        collection = new HashSet();
        for (CALSColSpec cALSColSpec : set) {
            collection.add((AuthorNode)((Object)cALSColSpec.getColumnName()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl5 = false;
        while (var19_34 < n3) {
            void var20_43;
            if (n5 != -1) {
                void var16_23;
                stringBuilder.append("<").append((String)var16_23);
                if (string != null) {
                    stringBuilder.append(" xmlns=\"").append(string).append("\"");
                }
                if (bl3) {
                    stringBuilder.append(" ").append("colnum");
                    stringBuilder.append("=\"").append(n2 + var19_34 + 1).append("\"");
                }
                Object var20_39 = null;
                if (bl4) {
                    void var20_41;
                    if (tableColumnSpecificationInformation instanceof CALSTableColumnSpecificationInformation) {
                        String string5 = ((CALSTableColumnSpecificationInformation)tableColumnSpecificationInformation).getColumnName();
                    }
                    if (var20_41 == null) {
                        String string6 = InsertColumnOperation.getUniqueColSpecName(collection, n2 + var19_34 + 1);
                        collection.add((AuthorNode)((Object)string6));
                    }
                    stringBuilder.append(" ").append("colname");
                    stringBuilder.append("=\"").append((String)var20_43).append("\"");
                }
                if (bl2) {
                    WidthRepresentation widthRepresentation2;
                    String string7 = this.getDefaultColWidthValue();
                    if (widthRepresentation != null && widthRepresentation.getWidthRepresentation() != null) {
                        string7 = widthRepresentation.getWidthRepresentation();
                    }
                    if (tableColumnSpecificationInformation != null && (widthRepresentation2 = tableColumnSpecificationInformation.getWidthRepresentation()) != null) {
                        string7 = widthRepresentation2.getWidthRepresentation();
                    }
                    if (string7 != null) {
                        stringBuilder.append(" ").append("colwidth");
                        stringBuilder.append("=\"").append(string7).append("\"");
                    }
                }
            } else {
                throw new AuthorOperationException("Could not compute the index of the column to be inserted.");
            }
            stringBuilder.append("/>");
            collection.add((AuthorNode)var20_43);
            ++var19_34;
        }
        authorAccess.getDocumentController().insertXMLFragment(stringBuilder.toString(), n5);
    }

    protected String getDefaultColWidthValue() {
        return "1*";
    }

    private static String getUniqueColSpecName(Set<String> set, int n2) {
        String string = "newCol" + n2;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            for (String string2 : set) {
                if (!string.equals(string2)) continue;
                bl = false;
                string = "newCol" + ++n2;
                continue block0;
            }
        }
        return string;
    }

    @Override
    protected String getCellElementName(AuthorElement authorElement, int n2) {
        return "entry";
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

