/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements CALSConstants {
    public DeleteColumnOperation() {
        this(new CALSDocumentTypeHelper());
    }

    public DeleteColumnOperation(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void updateColspec(AuthorAccess authorAccess, Integer n2) {
        CALSTableCellInfoProvider cALSTableCellInfoProvider = (CALSTableCellInfoProvider)this.tableHelper.getTableCellSpanProvider(this.tableElem);
        CALSColSpec cALSColSpec = cALSTableCellInfoProvider.getColSpec(n2 + 1);
        if (cALSColSpec != null) {
            List<AuthorNode> list = this.tableElem.getContentNodes();
            boolean bl = false;
            AuthorElement authorElement = cALSTableCellInfoProvider.getColSpecElement(cALSColSpec);
            for (AuthorNode authorNode : list) {
                AttrValue attrValue;
                if (!this.tableHelper.isColspec(authorNode)) continue;
                AuthorElement authorElement2 = (AuthorElement)authorNode;
                if (authorElement2 == authorElement) {
                    bl = true;
                }
                if (!bl || (attrValue = authorElement2.getAttribute("colnum")) == null || attrValue.getValue() == null) continue;
                try {
                    int n3 = NumberParserUtil.parseInt((String)attrValue.getValue());
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (n3 - 1)), authorElement2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (authorElement != null) {
                int n4 = authorAccess.getEditorAccess().getCaretOffset() - (authorElement.getEndOffset() - authorElement.getStartOffset() + 1);
                authorAccess.getDocumentController().deleteNode(authorElement);
                authorAccess.getEditorAccess().setCaretPosition(n4);
            }
        }
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) throws AuthorOperationException {
        if ((Integer)this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1) + 1 == n2) {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2 + 1, n3);
        } else if ((Integer)this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1) + 1 == n3) {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, n3 - 1);
        }
    }
}

