/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class TableCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)TableCustomizer.class.getName());
    private static final String TABLE_CUSTOMIZER_OPTIONS_KEY = "TABLE_CUSTOMIZER_OPTIONS";
    protected TableInfo tableInfo;

    public TableInfo customizeTable(AuthorAccess authorAccess) {
        return this.customizeTable(authorAccess, -1, -1);
    }

    public TableInfo customizeTable(AuthorAccess authorAccess, int n2, int n3) {
        return this.customizeTable(authorAccess, n2, n3, 0);
    }

    protected abstract TableInfo showCustomizeTableDialog(AuthorAccess var1, int var2, int var3, int var4);

    public TableInfo customizeTable(AuthorAccess authorAccess, int n2, int n3, int n4) {
        Object object;
        if (this.tableInfo == null) {
            object = authorAccess.getOptionsStorage().getOption(TABLE_CUSTOMIZER_OPTIONS_KEY, null);
            this.tableInfo = TableCustomizer.getTableInfoObject((String)object);
        }
        if ((object = this.showCustomizeTableDialog(authorAccess, n2, n3, n4)) != null) {
            int n5 = -1;
            int n6 = -1;
            if (n3 > 0 && n2 > 0 && n2 != ((TableInfo)object).getRowsNumber() && n3 != ((TableInfo)object).getColumnsNumber()) {
                if (this.tableInfo != null) {
                    n5 = this.tableInfo.getRowsNumber();
                    n6 = this.tableInfo.getColumnsNumber();
                } else {
                    n5 = 3;
                    n6 = 2;
                }
                this.tableInfo = new TableInfo(((TableInfo)object).getTitle(), n5, n6, ((TableInfo)object).isGenerateHeader(), ((TableInfo)object).isGenerateFooter(), ((TableInfo)object).getFrame(), ((TableInfo)object).getTableModel(), ((TableInfo)object).getColumnsWidthsType(), ((TableInfo)object).getRowsep(), ((TableInfo)object).getColsep(), ((TableInfo)object).getAlign());
            } else {
                this.tableInfo = object;
            }
            String string = this.serializeTableCustomizerOptions();
            if (string != null) {
                authorAccess.getOptionsStorage().setOption(TABLE_CUSTOMIZER_OPTIONS_KEY, string);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableInfo getTableInfoObject(String string) {
        TableInfo tableInfo = null;
        if (string != null) {
            ObjectInputStream objectInputStream = null;
            try {
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                tableInfo = (TableInfo)objectInputStream.readObject();
            }
            catch (IOException | ClassNotFoundException exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.error(iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }
        }
        return tableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeTableCustomizerOptions() {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.tableInfo);
            string = DatatypeConverter.printBase64Binary((byte[])byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
        }
        return string;
    }
}

