/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinRowCellsOperationBase
extends AbstractTableOperation {
    public JoinRowCellsOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        block14: {
            try {
                Object object;
                AuthorElement authorElement = null;
                AuthorNode authorNode = null;
                if (authorAccess.getEditorAccess().hasSelection()) {
                    int n2 = authorAccess.getEditorAccess().getSelectionStart();
                    int n3 = authorAccess.getEditorAccess().getSelectionEnd();
                    object = authorAccess.getEditorAccess().getFullySelectedNode();
                    if (object != null && object.getStartOffset() < object.getEndOffset() && this.tableHelper.isTableRow((AuthorNode)object)) {
                        ++n2;
                        --n3;
                    }
                    authorElement = this.getCell(authorAccess, n2, true);
                    authorNode = this.getCell(authorAccess, n3, false);
                } else {
                    AuthorNode authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                    if (this.tableHelper.isTableRow(authorNode2)) {
                        AuthorNode authorNode3 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() - 1);
                        if (this.tableHelper.isTableCell(authorNode3)) {
                            authorElement = (AuthorElement)authorNode3;
                        }
                        if (this.tableHelper.isTableCell((AuthorNode)(object = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() + 1)))) {
                            authorNode = (AuthorElement)object;
                        }
                    }
                }
                if (authorElement != null && authorNode != null && authorElement != authorNode) {
                    AuthorElement authorElement2;
                    AuthorElement authorElement3 = (AuthorElement)authorElement.getParent();
                    if (authorElement3 == (authorElement2 = (AuthorElement)authorNode.getParent())) {
                        object = this.getElementAncestor(authorElement3, 2);
                        if (object != null) {
                            AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider((AuthorElement)object);
                            if (!authorTableCellSpanProvider.hasColumnSpecifications((AuthorElement)object) && authorAccess.getWorkspaceAccess().showConfirmDialog("Column specifications", "Join cells operation requires column specifications. Do you want to generate them?", new String[]{"Yes", "No"}, new int[]{1, 0}) == 1) {
                                this.generateColumnSpecifications(authorAccess, authorTableCellSpanProvider, (AuthorElement)object);
                            }
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, authorElement);
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, (AuthorElement)authorNode);
                            List list = this.getCellsBetweenOffsets(authorElement3, authorElement.getEndOffset() + 1, authorNode.getEndOffset());
                            AuthorElement authorElement4 = authorElement;
                            this.checkForSameRowSpan(authorTableCellSpanProvider, authorElement4, list);
                            this.updateColSpanForMergedCell(authorAccess, authorTableCellSpanProvider, authorElement4, list);
                            int n4 = list.size();
                            for (int i2 = 0; i2 < n4; ++i2) {
                                AuthorElement authorElement5 = (AuthorElement)list.get(i2);
                                AuthorDocumentFragment authorDocumentFragment = null;
                                if (authorElement5.getEndOffset() - authorElement5.getStartOffset() > 1) {
                                    authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(authorElement5.getStartOffset() + 1, authorElement5.getEndOffset() - 1);
                                }
                                authorAccess.getDocumentController().deleteNode(authorElement5);
                                if (authorDocumentFragment == null) continue;
                                authorAccess.getDocumentController().insertFragment(authorElement4.getEndOffset(), authorDocumentFragment);
                            }
                            authorAccess.getEditorAccess().setCaretPosition(authorElement4.getEndOffset());
                        }
                        break block14;
                    }
                    object = new AuthorOperationException("The selected cells must be from the same table row.");
                    ((AuthorOperationException)object).setOperationRejectedOnPurpose(true);
                    throw object;
                }
                AuthorOperationException authorOperationException = new AuthorOperationException("The operation is enabled only when there is a selection that contains at least two cells from the same row of a table or when the caret is positioned between two horizontally adjacent cells.");
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Operation failed: " + badLocationException.getMessage(), badLocationException);
            }
        }
    }

    private void checkForSameRowSpan(AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, List list) throws AuthorOperationException {
        Integer n2 = authorTableCellSpanProvider.getRowSpan(authorElement);
        int n3 = n2 != null ? n2 : 1;
        for (AuthorElement authorElement2 : list) {
            Integer n4 = authorTableCellSpanProvider.getRowSpan(authorElement2);
            int n5 = n4 != null ? n4 : 1;
            if (n3 == n5) continue;
            AuthorOperationException authorOperationException = new AuthorOperationException("Join operation is possible only for cells with the same row span.");
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
    }

    protected AuthorElement getCell(AuthorAccess authorAccess, int n2, boolean bl) throws BadLocationException {
        AuthorElement authorElement = null;
        AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
        if (this.tableHelper.isTableRow(authorNode)) {
            AuthorNode authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(bl ? n2 + 1 : n2 - 1);
            if (this.tableHelper.isTableCell(authorNode2)) {
                authorElement = (AuthorElement)authorNode2;
            }
        } else {
            authorElement = this.getElementAncestor(authorNode, 0);
        }
        return authorElement;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Join the content of the selected cells. The operation is available only if the selected cells are from the same row and they have the same column span.";
    }

    private List getCellsBetweenOffsets(AuthorElement authorElement, int n2, int n3) {
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        List<AuthorNode> list = authorElement.getContentNodes();
        for (AuthorNode authorNode : list) {
            if (!(authorNode.getStartOffset() <= n2 && authorNode.getEndOffset() >= n2 || authorNode.getStartOffset() > n2 && authorNode.getEndOffset() < n3) && (authorNode.getStartOffset() > n3 || authorNode.getEndOffset() < n3) || !this.tableHelper.isTableCell(authorNode)) continue;
            arrayList.add(authorNode);
        }
        return arrayList;
    }

    private void updateColSpanForMergedCell(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, List list) throws AuthorOperationException {
        int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement);
        AuthorElement authorElement2 = (AuthorElement)list.get(list.size() - 1);
        int[] nArray2 = authorAccess.getTableAccess().getTableColSpanIndices(authorElement2);
        this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, nArray[0] + 1, nArray2[1] + 1);
    }

    protected abstract void generateColumnSpecifications(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3) throws AuthorOperationException;
}

