/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECCustomTableColumnInsertionDialog
extends TrayDialog {
    private TableColumnsInfo tableColumnsInfo;
    private int columns;
    private boolean insertAfter;
    private Spinner columnsSpinner;
    private Button beforeRadioButton;
    private Button afterRadioButton;
    private AuthorResourceBundle authorResourceBundle;

    protected ECCustomTableColumnInsertionDialog(Shell shell, AuthorResourceBundle authorResourceBundle) {
        super(shell);
        this.authorResourceBundle = authorResourceBundle;
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.authorResourceBundle.getMessage("insert.table.columns.custom"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(this.authorResourceBundle.getMessage("Number_of_columns") + ":");
        this.columnsSpinner = new Spinner(composite2, 2048);
        this.columnsSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnsSpinner.setLayoutData((Object)gridData);
        this.columnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ECCustomTableColumnInsertionDialog.this.columns = ECCustomTableColumnInsertionDialog.this.columnsSpinner.getSelection();
            }
        });
        this.columns = new TableColumnsInfo().getColumnsNumber();
        Label label2 = new Label(composite2, 0);
        label2.setText(this.authorResourceBundle.getMessage("Position") + ":");
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new RowLayout());
        this.beforeRadioButton = new Button(composite3, 16);
        this.beforeRadioButton.setText(this.authorResourceBundle.getMessage("Before"));
        this.beforeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = false;
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = false;
            }
        });
        this.afterRadioButton = new Button(composite3, 16);
        this.afterRadioButton.setText(this.authorResourceBundle.getMessage("After"));
        this.afterRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = true;
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = true;
            }
        });
        this.initialize();
        return composite2;
    }

    public TableColumnsInfo showDialog(TableColumnsInfo tableColumnsInfo) {
        this.tableColumnsInfo = tableColumnsInfo;
        if (0 == this.open()) {
            return new TableColumnsInfo(this.columns, this.insertAfter);
        }
        return null;
    }

    private void initialize() {
        if (this.tableColumnsInfo != null) {
            this.columns = this.tableColumnsInfo.getColumnsNumber();
            this.columnsSpinner.setSelection(this.columns);
            this.insertAfter = this.tableColumnsInfo.isInsertAfter();
            this.beforeRadioButton.setSelection(!this.insertAfter);
            this.afterRadioButton.setSelection(this.insertAfter);
        } else {
            TableColumnsInfo tableColumnsInfo = new TableColumnsInfo();
            this.columns = tableColumnsInfo.getColumnsNumber();
            this.columnsSpinner.setSelection(this.columns);
            this.insertAfter = tableColumnsInfo.isInsertAfter();
            this.beforeRadioButton.setSelection(!this.insertAfter);
            this.afterRadioButton.setSelection(this.insertAfter);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setText(this.authorResourceBundle.getMessage("Insert"));
    }
}

