/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class DeleteRowOperationBase
extends AbstractTableOperation {
    public DeleteRowOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performDeleteRows(AuthorAccess authorAccess, List<ContentInterval> list) throws AuthorOperationException {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            boolean bl2 = list != null && !list.isEmpty();
            AuthorNode authorNode = authorDocumentController.getNodeAtOffset(bl2 ? list.get(0).getStartOffset() : authorAccess.getEditorAccess().getCaretOffset());
            AuthorElement authorElement = this.getElementAncestor(authorNode, 2);
            if (authorElement == null) throw new AuthorOperationException("The caret must be inside a table");
            List<Object> list2 = new ArrayList<AuthorElement>(1);
            if (bl2) {
                object2 = new ArrayList<Integer[]>(list.size());
                for (ContentInterval contentInterval : list) {
                    object2.add(new Integer[]{contentInterval.getStartOffset(), contentInterval.getEndOffset()});
                }
                list2 = TableOperationsUtil.getTableElementsOfType(authorAccess, object2, 0, TableOperationsUtil.createTableHelper(this.tableHelper));
            } else if (authorEditorAccess.hasSelection()) {
                list2 = TableOperationsUtil.getTableElementsOfTypeFromSelection(authorAccess, 0, TableOperationsUtil.createTableHelper(this.tableHelper), authorElement);
            } else {
                list2.add(this.getElementAncestor(authorNode, 1));
            }
            if (list2.isEmpty()) return bl;
            object2 = authorAccess.getTableAccess();
            if (list2.size() == object2.getTableRowCount(authorElement)) {
                object = this.tableHelper.getTableElementForDeletion(authorElement);
                if (object == null) return bl;
                authorDocumentController.deleteNode((AuthorNode)object);
                return bl;
            } else {
                int n2;
                Object object32;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                object = (AuthorElement)list2.get(list2.size() - 1);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n3 = object2.getTableRowCount(authorElement);
                Object object8 = null;
                Object object9 = null;
                boolean bl3 = false;
                for (int i2 = 0; i2 < n3; ++i2) {
                    object7 = object2.getTableRow(i2, authorElement);
                    if (list2.contains(object7)) {
                        arrayList.add(i2);
                        if (!Equaler.verifyEquals((Object)object, (Object)object7)) continue;
                        bl3 = true;
                        continue;
                    }
                    if (!bl3) {
                        object8 = object7;
                        continue;
                    }
                    if (object9 != null) continue;
                    object9 = object7;
                }
                Position position = null;
                if (object9 != null) {
                    position = authorDocumentController.createPositionInContent(object9.getStartOffset() + 1);
                } else if (object8 != null) {
                    position = authorDocumentController.createPositionInContent(object8.getStartOffset() + 1);
                }
                object7 = new HashMap();
                int n4 = arrayList.size();
                int n5 = -1;
                int n6 = object2.getTableNumberOfColumns(authorElement);
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
                for (int i3 = 0; i3 < n4; ++i3) {
                    n5 = (Integer)arrayList.get(i3);
                    object6 = null;
                    for (int i4 = n6 - 1; i4 >= 0; --i4) {
                        int n7;
                        object5 = object2.getTableCellAt(n5, i4, authorElement);
                        if (object5 == null) continue;
                        int[] nArray = object2.getTableCellIndex((AuthorElement)object5);
                        Integer n8 = authorTableCellSpanProvider.getColSpan((AuthorElement)object5);
                        object4 = authorTableCellSpanProvider.getRowSpan((AuthorElement)object5);
                        int n9 = n8 != null ? n8 : 1;
                        int n10 = n7 = object4 != null ? (Integer)object4 : 1;
                        if (n7 > 1) {
                            if (nArray[0] == n5) {
                                if (object6 == null) {
                                    object6 = this.createSplitCellOperation();
                                }
                                ((SplitCellAboveBelowOperationBase)object6).splitCell((AuthorElement)object5, authorAccess, true);
                            } else {
                                Integer n11 = (Integer)object7.get(object5);
                                if (n11 == null) {
                                    object7.put(object5, n7 - 1);
                                } else {
                                    object7.put(object5, n11 - 1);
                                }
                            }
                        }
                        if (n9 <= 1) continue;
                        i4 -= n9 - 1;
                    }
                    object32 = object2.getTableRow((Integer)arrayList.get(i3), authorElement);
                    linkedHashSet.add(object32);
                    if (!linkedHashSet.containsAll(object32.getParentElement().getContentNodes())) continue;
                    linkedHashSet.add((AuthorElement)object32.getParentElement());
                    linkedHashSet.removeAll(object32.getParentElement().getContentNodes());
                }
                Set set = object7.keySet();
                for (Object object32 : set) {
                    this.tableHelper.updateTableRowSpan(authorAccess, (AuthorElement)object32, (Integer)object7.get(object32));
                }
                object6 = new ArrayList(linkedHashSet);
                Collections.sort(object6, new Comparator<AuthorElement>(){

                    @Override
                    public int compare(AuthorElement authorElement, AuthorElement authorElement2) {
                        int n2 = 0;
                        n2 = authorElement.getStartOffset() < authorElement2.getStartOffset() ? -1 : 1;
                        return n2;
                    }
                });
                object32 = new int[object6.size()];
                object5 = new int[object6.size()];
                int n12 = object6.size();
                for (n2 = 0; n2 < n12; ++n2) {
                    object32[n2] = ((AuthorElement)object6.get(n2)).getStartOffset();
                    object5[n2] = ((AuthorElement)object6.get(n2)).getEndOffset();
                }
                authorAccess.getDocumentController().multipleDelete(authorElement, (int[])object32, (int[])object5);
                bl = true;
                this.tableHelper.updateTableRowNumber(authorAccess, authorElement, -arrayList.size());
                n2 = object2.getTableRowCount(authorElement);
                if (n2 <= 0) return bl;
                if (position != null) {
                    authorEditorAccess.setCaretPosition(position.getOffset());
                    return bl;
                } else {
                    object4 = object2.getTableRow(0, authorElement);
                    if (object4 == null) return bl;
                    authorEditorAccess.setCaretPosition(object4.getStartOffset() + 1);
                    return bl;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    public boolean performDeleteRows(AuthorAccess authorAccess, int n2, int n3) throws AuthorOperationException {
        ArrayList<ContentInterval> arrayList = null;
        if (n2 >= 0 && n3 >= 0) {
            arrayList = new ArrayList<ContentInterval>(1);
            arrayList.add(new ContentInterval(n2, n3));
        }
        return this.performDeleteRows(authorAccess, arrayList);
    }

    @Override
    public final void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        this.performDeleteRows(authorAccess, -1, -1);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{CHANGE_TRACKING_BEHAVIOR_ARGUMENT};
    }

    @Override
    public String getDescription() {
        return "Delete table rows. If there is a selection in the table all the rows that intersect that selection are removed. If there is no selection in the table, the row at caret is deleted.";
    }

    protected abstract SplitCellAboveBelowOperationBase createSplitCellOperation();
}

