/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class SortUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SortUtil.class.getName());

    private SortUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static String detectXMLLangFrom(AuthorNode authorNode) {
        String string = null;
        if (authorNode != null) {
            if (authorNode.getType() == 0) {
                String string2;
                AttrValue attrValue = ((AuthorElement)authorNode).getAttribute("xml:lang");
                String string3 = string2 = attrValue != null ? attrValue.getValue() : null;
                if (string2 == null) {
                    attrValue = ((AuthorElement)authorNode).getAttribute("lang");
                    String string4 = string2 = attrValue != null ? attrValue.getValue() : null;
                }
                string = string2 != null ? string2 : SortUtil.detectXMLLangFrom(authorNode.getParent());
            } else {
                string = SortUtil.detectXMLLangFrom(authorNode.getParent());
            }
        }
        return string;
    }

    static Date parseXsdDatetime(AuthorOperationException[] authorOperationExceptionArray, String string) {
        Date date = null;
        Calendar calendar = null;
        try {
            calendar = DatatypeConverter.parseDateTime((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                calendar = DatatypeConverter.parseDate((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    calendar = DatatypeConverter.parseTime((String)string);
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    authorOperationExceptionArray[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + string + "\"", illegalArgumentException3);
                }
            }
        }
        if (calendar != null) {
            long l2 = calendar.getTimeInMillis();
            date = new Date(l2);
        }
        return date;
    }

    static Date parseDate(AuthorOperationException[] authorOperationExceptionArray, String string, DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
        Date date = null;
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                date = dateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    date = dateFormat3.parse(string);
                }
                catch (ParseException parseException3) {
                    authorOperationExceptionArray[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + string + "\"");
                }
            }
        }
        return date;
    }

    static Double parseNumber(AuthorOperationException[] authorOperationExceptionArray, String string) {
        Double d2 = 0.0;
        if (string.isEmpty()) {
            d2 = Double.MIN_VALUE;
        } else {
            try {
                d2 = NumberParserUtil.parseDouble((String)string);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.debug((Object)numberFormatException, (Throwable)numberFormatException);
                authorOperationExceptionArray[0] = new AuthorOperationException("Unable to parse the following text value as a number:\n\"" + string + "\"", numberFormatException);
            }
        }
        return d2;
    }
}

