/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Frame;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.ECSortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SASortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortUtil;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SortOperation
implements AuthorOperation {
    private static final String SORTING_SUPPORT_PAGE_ID = "sorting-support";
    private static final Logger logger = LoggerFactory.getLogger((String)SortOperation.class.getName());
    protected static final String COLUMN = "Column";
    protected AuthorAccess authorAccess;
    private SortCriteriaInformation sortInformation = null;
    private final String selElementsString;
    private final String allElementsString;

    public SortOperation(String string, String string2) {
        this.selElementsString = string;
        this.allElementsString = string2;
    }

    @Override
    public String getDescription() {
        return "Sort operation";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        block14: {
            this.authorAccess = authorAccess;
            try {
                int n2;
                Object badLocationException;
                List<CriterionInformation> list;
                AuthorElement authorElement;
                int n3 = authorAccess.getEditorAccess().getCaretOffset();
                List<ContentInterval> list2 = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
                if (list2 != null && !list2.isEmpty()) {
                    n3 = list2.get(0).getStartOffset();
                }
                if ((authorElement = this.getSortParent(n3, authorAccess)) == null || (list = this.getSortCriteria(authorElement)).isEmpty()) break block14;
                int[] nArray = this.getSelectedNonIgnoredChildrenInterval(authorElement);
                this.sortInformation = this.getSortInformation(authorAccess, authorElement, list, nArray);
                if (this.sortInformation == null || this.sortInformation.criteriaInfo == null || this.sortInformation.criteriaInfo.length <= 0) break block14;
                Locale locale = Locale.getDefault();
                String string = SortUtil.detectXMLLangFrom(authorElement);
                if (string != null) {
                    locale = SortOperation.createLocale(string);
                }
                AuthorOperationException[] authorOperationExceptionArray = new AuthorOperationException[1];
                TreeSet<SortableFragment> treeSet = new TreeSet<SortableFragment>(this.createNodesComparator(locale, authorOperationExceptionArray));
                int n4 = 0;
                int n5 = 0;
                List<AuthorNode> list3 = authorElement.getContentNodes();
                ArrayList<AuthorDocumentFragment> arrayList = new ArrayList<AuthorDocumentFragment>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (AuthorNode object22 : list3) {
                    try {
                        if (this.isIgnored(object22) || this.sortInformation.onlySelectedElements && nArray != null && (nArray[0] > n5 || nArray[1] < n5)) {
                            arrayList.add(authorAccess.getDocumentController().createDocumentFragment(object22, true));
                            arrayList2.add(n4);
                        } else {
                            badLocationException = new SortableFragment();
                            ((SortableFragment)badLocationException).documentFragment = authorAccess.getDocumentController().createDocumentFragment(object22, true);
                            ((SortableFragment)badLocationException).keyValues = this.getSortKeysValues(object22, this.sortInformation);
                            treeSet.add((SortableFragment)badLocationException);
                            if (authorOperationExceptionArray[0] != null) {
                                throw authorOperationExceptionArray[0];
                            }
                        }
                    }
                    catch (BadLocationException badLocationException2) {
                        logger.error((Object)badLocationException2, (Throwable)badLocationException2);
                        throw new AuthorOperationException(badLocationException2.getMessage(), badLocationException2);
                    }
                    if (!this.isIgnored(object22)) {
                        ++n5;
                    }
                    ++n4;
                }
                AuthorDocumentFragment[] authorDocumentFragmentArray = new AuthorDocumentFragment[treeSet.size() + arrayList.size()];
                int[] nArray2 = new int[authorDocumentFragmentArray.length];
                badLocationException = arrayList.iterator();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext() && badLocationException.hasNext()) {
                    n2 = (Integer)iterator.next();
                    authorDocumentFragmentArray[n2] = (AuthorDocumentFragment)badLocationException.next();
                }
                nArray2[0] = authorElement.getStartOffset() + 1;
                iterator = treeSet.iterator();
                for (n2 = 0; n2 < authorDocumentFragmentArray.length; ++n2) {
                    if (authorDocumentFragmentArray[n2] == null && iterator.hasNext()) {
                        AuthorDocumentFragment authorDocumentFragment;
                        authorDocumentFragmentArray[n2] = authorDocumentFragment = ((SortableFragment)iterator.next()).documentFragment;
                    }
                    if (n2 <= 0) continue;
                    nArray2[n2] = authorElement.getStartOffset() + 1;
                }
                authorAccess.getDocumentController().multipleDelete(authorElement, new int[]{authorElement.getStartOffset() + 1}, new int[]{authorElement.getEndOffset()});
                authorAccess.getDocumentController().insertMultipleFragments(authorElement, authorDocumentFragmentArray, nArray2);
                authorAccess.getEditorAccess().setCaretPosition(n3);
            }
            catch (AuthorOperationException authorOperationException) {
                authorAccess.getWorkspaceAccess().showErrorMessage("The sort operation couldn't be performed.\n" + authorOperationException.getMessage(), authorOperationException);
            }
        }
    }

    private SortCriteriaInformation getSortInformation(AuthorAccess authorAccess, AuthorElement authorElement, List<CriterionInformation> list, int[] nArray) throws AuthorOperationException {
        this.canBeSorted(authorElement, nArray);
        SortCriteriaInformation sortCriteriaInformation = null;
        boolean bl = false;
        try {
            this.canBeSorted(authorElement, new int[]{0, this.getNonIgnoredChildren(authorElement).size() - 1});
        }
        catch (AuthorOperationException authorOperationException) {
            bl = true;
        }
        Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
        if (Platform.STANDALONE == platform) {
            SASortCustomizerDialog sASortCustomizerDialog = new SASortCustomizerDialog((Frame)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString)){

                @Override
                public String getHelpPageID() {
                    return SortOperation.this.getHelpPageID();
                }
            };
            sortCriteriaInformation = sASortCustomizerDialog.getSortInformation(list, nArray != null, bl);
        } else if (Platform.ECLIPSE == platform) {
            sortCriteriaInformation = new ECSortCustomizerDialog((Shell)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString), this.getHelpPageID()).getSortInformation(list, nArray != null, bl);
        }
        return sortCriteriaInformation;
    }

    private Comparator<SortableFragment> createNodesComparator(final Locale locale, final AuthorOperationException[] authorOperationExceptionArray) {
        return new Comparator<SortableFragment>(){

            @Override
            public int compare(SortableFragment sortableFragment, SortableFragment sortableFragment2) {
                for (int i2 = 0; sortableFragment.keyValues != null && sortableFragment2.keyValues != null && i2 < sortableFragment.keyValues.length; ++i2) {
                    Object object;
                    if (sortableFragment.keyValues[i2] == null && sortableFragment2.keyValues[i2] != null) {
                        return CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getOrder()) ? 1 : -1;
                    }
                    if (sortableFragment2.keyValues[i2] == null) {
                        return CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getOrder()) ? -1 : 1;
                    }
                    if (sortableFragment.keyValues[i2].trim().equals(sortableFragment2.keyValues[i2].trim())) continue;
                    int n2 = 0;
                    sortableFragment.keyValues[i2] = sortableFragment.keyValues[i2].trim();
                    sortableFragment2.keyValues[i2] = sortableFragment2.keyValues[i2].trim();
                    if (CriterionInformation.TYPE.NUMERIC.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getType())) {
                        object = SortUtil.parseNumber(authorOperationExceptionArray, sortableFragment.keyValues[i2]);
                        if (authorOperationExceptionArray[0] == null) {
                            Double d2 = SortUtil.parseNumber(authorOperationExceptionArray, sortableFragment2.keyValues[i2]);
                            if (authorOperationExceptionArray[0] == null) {
                                n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getOrder()) ? ((Double)object).compareTo(d2) : d2.compareTo((Double)object);
                            }
                        }
                    } else if (CriterionInformation.TYPE.DATE.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getType())) {
                        object = new int[]{2, 3, 2, 1, 0};
                        Date date = null;
                        Date date2 = null;
                        for (int i3 = 0; i3 < ((Object)object).length && (date == null || date2 == null); ++i3) {
                            Object object2 = object[i3];
                            Locale locale2 = Locale.getDefault();
                            DateFormat dateFormat = DateFormat.getDateTimeInstance((int)object2, (int)object2, locale2);
                            DateFormat dateFormat2 = DateFormat.getDateInstance((int)object2, locale2);
                            DateFormat dateFormat3 = DateFormat.getTimeInstance((int)object2, locale2);
                            if (date == null) {
                                date = SortUtil.parseDate(authorOperationExceptionArray, sortableFragment.keyValues[i2], dateFormat, dateFormat2, dateFormat3);
                            }
                            if (date2 != null) continue;
                            date2 = SortUtil.parseDate(authorOperationExceptionArray, sortableFragment2.keyValues[i2], dateFormat, dateFormat2, dateFormat3);
                        }
                        if (date == null) {
                            date = SortUtil.parseXsdDatetime(authorOperationExceptionArray, sortableFragment.keyValues[i2]);
                        }
                        if (date2 == null) {
                            date2 = SortUtil.parseXsdDatetime(authorOperationExceptionArray, sortableFragment2.keyValues[i2]);
                        }
                        if (date != null && date2 != null) {
                            n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getOrder()) ? date.compareTo(date2) : date2.compareTo(date);
                            authorOperationExceptionArray[0] = null;
                        }
                    } else {
                        object = Collator.getInstance(locale);
                        ((Collator)object).setStrength(2);
                        ((Collator)object).setDecomposition(2);
                        int n3 = ((Collator)object).compare(sortableFragment.keyValues[i2], sortableFragment2.keyValues[i2]);
                        int n4 = n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[i2].getOrder()) ? n3 : -n3;
                    }
                    if (authorOperationExceptionArray[0] != null) break;
                    if (n2 == 0) continue;
                    return n2;
                }
                return 1;
            }
        };
    }

    private static Locale createLocale(String string) {
        int n2 = string.indexOf(45);
        String string2 = string;
        String string3 = "";
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            String[] stringArray = Locale.getISOLanguages();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].equalsIgnoreCase(string2)) continue;
                string2 = stringArray[i2];
            }
            string3 = string.substring(n2 + 1);
            String[] stringArray2 = Locale.getISOCountries();
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                if (!stringArray2[i3].equalsIgnoreCase(string2)) continue;
                string3 = stringArray2[i3];
            }
        }
        return new Locale(string2, string3);
    }

    public abstract void canBeSorted(AuthorElement var1, int[] var2) throws AuthorOperationException;

    public int[] getSelectedNonIgnoredChildrenInterval(AuthorElement authorElement) {
        int[] nArray = null;
        if (this.authorAccess.getEditorAccess().hasSelection()) {
            if (this.forceSortAll()) {
                return null;
            }
            List<ContentInterval> list = this.authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            int n2 = 0;
            int n3 = -1;
            List<AuthorNode> list2 = this.getNonIgnoredChildren(authorElement);
            boolean bl = true;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ContentInterval contentInterval = list.get(i2);
                int[] nArray2 = SortOperation.getSelectionElementsIndices(list2, contentInterval.getStartOffset(), contentInterval.getEndOffset());
                if (i2 == 0) {
                    n2 = nArray2[0];
                    n3 = nArray2[1];
                    continue;
                }
                if (nArray2[0] - 1 == n3) {
                    n3 = nArray2[1];
                    continue;
                }
                bl = false;
                break;
            }
            if (bl) {
                nArray = new int[]{n2, n3};
            }
        }
        return nArray;
    }

    protected boolean forceSortAll() {
        return false;
    }

    private static int[] getSelectionElementsIndices(List<AuthorNode> list, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        int n6 = list.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (authorNode.getStartOffset() <= n2 && authorNode.getEndOffset() >= n2 || n4 == -1 && n2 <= authorNode.getStartOffset() && n3 > authorNode.getStartOffset()) {
                n4 = i2;
            }
            if ((authorNode.getStartOffset() >= n3 || authorNode.getEndOffset() < n3) && (n2 > authorNode.getEndOffset() || n3 <= authorNode.getEndOffset())) continue;
            n5 = i2;
        }
        return new int[]{n4, n5};
    }

    protected List<AuthorNode> getNonIgnoredChildren(AuthorElement authorElement) {
        ExtensionsBundle extensionsBundle = this.authorAccess.getEditorAccess().getExtensionsBundle();
        if (extensionsBundle != null) {
            authorElement = (AuthorElement)CommonAccess.getContentReferencedNode(extensionsBundle, authorElement);
        }
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        List<AuthorNode> list = authorElement.getContentNodes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (this.isIgnored(authorNode)) continue;
            arrayList.add(authorNode);
        }
        return arrayList;
    }

    public abstract AuthorElement getSortParent(int var1, AuthorAccess var2) throws AuthorOperationException;

    public abstract boolean isIgnored(AuthorNode var1);

    public abstract String[] getSortKeysValues(AuthorNode var1, SortCriteriaInformation var2) throws AuthorOperationException;

    public abstract List<CriterionInformation> getSortCriteria(AuthorElement var1) throws AuthorOperationException;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected String getTextContentToSort(AuthorNode authorNode) {
        TextContentIterator textContentIterator = this.authorAccess.getDocumentController().getTextContentIterator(authorNode.getStartOffset(), authorNode.getEndOffset());
        StringBuilder stringBuilder = new StringBuilder();
        while (textContentIterator.hasNext()) {
            TextContext textContext = textContentIterator.next();
            if (textContext.getEditableState() == 2) continue;
            stringBuilder.append(textContext.getText());
        }
        return stringBuilder.toString().trim();
    }

    protected String getHelpPageID() {
        return SORTING_SUPPORT_PAGE_ID;
    }

    private static class SortableFragment {
        private AuthorDocumentFragment documentFragment;
        private String[] keyValues;

        private SortableFragment() {
        }
    }
}

