/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.TableSortOperation;
import ro.sync.ecss.extensions.commons.sort.TableSortUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SimpleTableSortOperation
extends TableSortOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SimpleTableSortOperation.class.getName());

    @Override
    public AuthorElement getSortParent(int n2, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode;
        AuthorElement authorElement = null;
        if (authorAccess.getEditorAccess().hasSelection() && (authorNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && authorNode.getType() == 0 && this.isTableElement((AuthorElement)authorNode)) {
            authorElement = (AuthorElement)authorNode;
        }
        if (authorElement == null) {
            try {
                AuthorNode authorNode2 = authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
                while (authorNode2.getType() != 2) {
                    if (authorNode2.getType() == 0 && this.isTableElement((AuthorElement)authorNode2)) {
                        authorElement = (AuthorElement)authorNode2;
                        break;
                    }
                    authorNode2 = authorNode2.getParent();
                }
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
            }
        }
        return authorElement;
    }

    @Override
    public boolean isIgnored(AuthorNode authorNode) {
        boolean bl = false;
        if (authorNode.getType() == 0) {
            bl = this.isHeadElement((AuthorElement)authorNode);
        }
        return authorNode.getType() == 3 || authorNode.getType() == 5 || bl;
    }

    @Override
    public String[] getSortKeysValues(AuthorNode authorNode, SortCriteriaInformation sortCriteriaInformation) throws AuthorOperationException {
        CriterionInformation[] criterionInformationArray = sortCriteriaInformation.criteriaInfo;
        String[] stringArray = null;
        if (authorNode instanceof AuthorElement && criterionInformationArray.length > 0) {
            stringArray = new String[criterionInformationArray.length];
            AuthorElement authorElement = (AuthorElement)authorNode;
            ExtensionsBundle extensionsBundle = this.authorAccess.getEditorAccess().getExtensionsBundle();
            if (extensionsBundle != null) {
                authorElement = (AuthorElement)CommonAccess.getContentReferencedNode(extensionsBundle, authorElement);
            }
            if (this.isRowElement(authorElement)) {
                List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
                int n2 = list.size();
                for (int i2 = 0; i2 < criterionInformationArray.length; ++i2) {
                    CriterionInformation criterionInformation = criterionInformationArray[i2];
                    int n3 = criterionInformation.getKeyIndex();
                    AuthorNode authorNode2 = null;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int[] nArray;
                        AuthorNode authorNode3 = list.get(i3);
                        if (!(authorNode3 instanceof AuthorElement) || (nArray = this.authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode3)) == null || nArray[0] > n3 || nArray[1] < n3) continue;
                        authorNode2 = authorNode3;
                        break;
                    }
                    if (authorNode2 == null) continue;
                    stringArray[i2] = this.getTextContentToSort(authorNode2);
                }
            }
        }
        return stringArray;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement authorElement) throws AuthorOperationException {
        ArrayList<CriterionInformation> arrayList;
        block8: {
            Object object;
            AuthorElement authorElement2;
            block9: {
                Object object2;
                arrayList = new ArrayList<CriterionInformation>();
                List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
                int n2 = 0;
                authorElement2 = null;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    int n3;
                    object2 = list.get(i2);
                    if (object2.getType() != 0 || !this.isRowElement((AuthorElement)object2) || (n3 = this.getNonIgnoredChildren((AuthorElement)object2).size()) <= n2) continue;
                    authorElement2 = (AuthorElement)object2;
                    n2 = n3;
                }
                AuthorElement authorElement3 = null;
                if (this.isTableElement(authorElement)) {
                    authorElement3 = authorElement;
                }
                if (authorElement3 == null) break block8;
                object2 = authorElement3.getContentNodes();
                AuthorParentNode authorParentNode = null;
                for (int i3 = 0; i3 < object2.size(); ++i3) {
                    AuthorElement authorElement4;
                    object = (AuthorNode)object2.get(i3);
                    if (object.getType() != 0 || !this.isHeadElement(authorElement4 = (AuthorElement)object)) continue;
                    authorParentNode = authorElement4;
                    break;
                }
                AuthorParentNode authorParentNode2 = null;
                if (authorParentNode != null && this.isTableElement(authorElement) && authorParentNode.getContentNodes().size() == n2) {
                    authorParentNode2 = authorParentNode;
                }
                if (authorParentNode2 == null || authorElement2 == null) break block9;
                object = this.getNonIgnoredChildren((AuthorElement)authorParentNode2);
                for (int i4 = 0; i4 < n2; ++i4) {
                    AuthorNode authorNode = object.get(i4);
                    if (authorNode.getType() != 0) continue;
                    try {
                        AuthorElement authorElement5 = (AuthorElement)authorNode;
                        String string = authorElement5.getTextContent();
                        arrayList.add(new CriterionInformation(i4, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), (String)(string.length() > 0 ? string : "Column " + (i4 + 1)), TableSortUtil.isEntirelySelected(this.authorAccess, authorElement5) || this.isCaretInColumn(this.authorAccess, i4)));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
                    }
                }
                break block8;
            }
            if (authorElement2 == null) break block8;
            object = this.getNonIgnoredChildren(authorElement2);
            for (int i5 = 0; i5 < object.size(); ++i5) {
                if (object.get(i5).getType() != 0) continue;
                arrayList.add(new CriterionInformation(i5, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), "Column " + (i5 + 1), TableSortUtil.isEntirelySelected(this.authorAccess, (AuthorElement)object.get(i5)) || this.isCaretInColumn(this.authorAccess, i5)));
            }
        }
        return arrayList;
    }

    @Override
    protected boolean forceSortAll() {
        return TableSortUtil.isColumnOrTableSelection(this.authorAccess);
    }

    public boolean isCaretInColumn(AuthorAccess authorAccess, int n2) {
        if (n2 < 0) {
            return false;
        }
        boolean bl = false;
        int n3 = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n3);
            if (authorNode != null && authorNode.getType() == 0 && authorNode.getParent().getType() == 0 && this.isRowElement((AuthorElement)authorNode.getParent())) {
                List<AuthorNode> list = this.getNonIgnoredChildren((AuthorElement)authorNode.getParent());
                int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode);
                if (nArray != null) {
                    if (nArray[0] <= n2 && nArray[1] >= n2) {
                        bl = true;
                    }
                } else if (n2 < list.size()) {
                    bl = list.get(n2) == authorNode;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.debug(badLocationException.getMessage(), (Throwable)badLocationException);
        }
        return bl;
    }

    @Override
    protected int getRowIndexForTableBody(AuthorNode authorNode) {
        return 0;
    }

    public abstract boolean isTableElement(AuthorElement var1);

    public abstract boolean isHeadElement(AuthorElement var1);

    public abstract boolean isRowElement(AuthorElement var1);
}

