/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.KeysController;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class CriterionPanel {
    private JCheckBox keyCheckbox;
    private JComboBox keyCombo;
    private JComboBox typeCombo;
    private JComboBox orderCombo;
    private boolean addCheckbox;
    private final List<CriterionInformation> allCriteria;

    public CriterionPanel(Container container, GridBagConstraints gridBagConstraints, List<CriterionInformation> list, CriterionInformation criterionInformation, final AuthorResourceBundle authorResourceBundle, final KeysController keysController, List<CriterionInformation> list2) {
        this.allCriteria = list2;
        this.addCheckbox = list2.size() > 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 7, 7);
        if (this.addCheckbox) {
            this.keyCheckbox = new JCheckBox();
            container.add((Component)this.keyCheckbox, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.keyCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CriterionPanel.this.changeControlsState();
                }
            });
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.33;
        this.keyCombo = new JComboBox();
        this.keyCombo.setToolTipText(authorResourceBundle.getMessage("Select_key_column_tooltip"));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            CriterionInformation criterionInformation2 = list.get(i2);
            this.keyCombo.addItem(criterionInformation2.getDisplayName());
        }
        if (this.keyCombo.getPreferredSize().width < 75) {
            this.keyCombo.setPreferredSize(new Dimension(75, this.keyCombo.getPreferredSize().height));
            this.keyCombo.setMinimumSize(new Dimension(75, this.keyCombo.getPreferredSize().height));
        } else if (this.keyCombo.getPreferredSize().width > 150) {
            this.keyCombo.setPreferredSize(new Dimension(150, this.keyCombo.getPreferredSize().height));
            this.keyCombo.setMaximumSize(new Dimension(150, this.keyCombo.getPreferredSize().height));
        }
        this.keyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)CriterionPanel.this.keyCombo.getSelectedItem();
                if (string != null) {
                    keysController.selectionChanged(string, null);
                }
            }
        });
        if (criterionInformation != null) {
            this.keyCombo.setSelectedItem(criterionInformation.getDisplayName());
        } else {
            this.keyCombo.setSelectedItem(list.get(0).getDisplayName());
        }
        container.add((Component)this.keyCombo, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.typeCombo = new JComboBox();
        this.typeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, authorResourceBundle.getMessage((String)object), n2, bl, bl2);
            }
        });
        this.typeCombo.setToolTipText(authorResourceBundle.getMessage("Select_type_combo_tooltip"));
        this.typeCombo.addItem(CriterionInformation.TYPE.TEXT.getName());
        this.typeCombo.addItem(CriterionInformation.TYPE.NUMERIC.getName());
        this.typeCombo.addItem(CriterionInformation.TYPE.DATE.getName());
        this.typeCombo.setSelectedIndex(0);
        container.add((Component)this.typeCombo, gridBagConstraints);
        this.orderCombo = new JComboBox();
        this.orderCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, authorResourceBundle.getMessage((String)object), n2, bl, bl2);
            }
        });
        this.orderCombo.addItem(CriterionInformation.ORDER.ASCENDING.getName());
        this.orderCombo.addItem(CriterionInformation.ORDER.DESCENDING.getName());
        this.orderCombo.setToolTipText(authorResourceBundle.getMessage("Select_order_combo_tooltip"));
        this.orderCombo.setSelectedIndex(0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        container.add((Component)this.orderCombo, gridBagConstraints);
        this.changeControlsState();
    }

    public CriterionInformation getInformation() {
        CriterionInformation criterionInformation = null;
        if (!this.addCheckbox || this.keyCheckbox.isSelected()) {
            int n2 = 0;
            if (this.keyCombo != null) {
                for (int i2 = 0; i2 < this.allCriteria.size(); ++i2) {
                    if (!this.allCriteria.get(i2).getDisplayName().equals(this.keyCombo.getSelectedItem())) continue;
                    n2 = i2;
                    break;
                }
            }
            criterionInformation = new CriterionInformation(n2, (String)this.typeCombo.getSelectedItem(), (String)this.orderCombo.getSelectedItem(), this.keyCombo != null ? (String)this.keyCombo.getSelectedItem() : "Column 1");
        }
        return criterionInformation;
    }

    public void enableSortcriterion() {
        this.keyCheckbox.setSelected(true);
        this.changeControlsState();
    }

    public JComboBox getKeyCombo() {
        return this.keyCombo;
    }

    private void changeControlsState() {
        this.keyCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
        this.typeCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
        this.orderCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
    }
}

