/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SelectedTextOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)SelectedTextOperation.class.getName());

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        authorDocumentController.beginCompoundEdit();
        try {
            if (authorEditorAccess.hasSelection()) {
                List<ContentInterval> list = authorEditorAccess.getAuthorSelectionModel().getSelectionIntervals();
                ArrayList<ContentInterval> arrayList = new ArrayList<ContentInterval>(list.size());
                List<int[]> list2 = SelectedTextOperation.convertSelectionIntervals(list);
                int n2 = authorEditorAccess.getCaretOffset();
                SelectionInterpretationMode selectionInterpretationMode = authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
                authorDocumentController.markSelection(list2, n2, selectionInterpretationMode, list2, n2, selectionInterpretationMode);
                int n3 = 0;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    ContentInterval contentInterval = list.get(i2);
                    try {
                        int n4 = contentInterval.getStartOffset() + n3;
                        int n5 = contentInterval.getEndOffset() + n3;
                        Position position = authorDocumentController.createPositionInContent(n5);
                        this.processContentRange(authorDocumentController, n4, n5 - 1);
                        ContentInterval contentInterval2 = new ContentInterval(n4, position.getOffset());
                        arrayList.add(contentInterval2);
                        n3 += position.getOffset() - n5;
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error((Object)badLocationException, (Throwable)badLocationException);
                    }
                }
                authorDocumentController.markSelection(SelectedTextOperation.convertSelectionIntervals(arrayList), authorEditorAccess.getCaretOffset(), authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode(), null, -1, null);
            }
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    private static List<int[]> convertSelectionIntervals(List<ContentInterval> list) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
        for (ContentInterval contentInterval : list) {
            arrayList.add(new int[]{contentInterval.getStartOffset(), contentInterval.getEndOffset()});
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContentRange(AuthorDocumentController authorDocumentController, int n2, int n3) {
        TextContentIterator textContentIterator = authorDocumentController.getTextContentIterator(n2, n3);
        try {
            authorDocumentController.beginCompoundEdit();
            while (textContentIterator.hasNext()) {
                TextContext textContext = textContentIterator.next();
                if (!textContext.inVisibleContent() || textContext.getEditableState() != 0 && textContext.getEditableState() != 1) continue;
                String string = textContext.getText().toString();
                string = this.processText(string);
                textContext.replaceText(string);
            }
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    protected abstract String processText(String var1);
}

