/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.xml.EscapingReader;
import ro.sync.basic.xml.UnescapeWriter;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.ElementLocationPath;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class TransformOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)TransformOperation.class.getName());
    public static final String CURRENT_ELEMENT_LOCATION = "currentElementLocation";
    public static final String ACTION_REPLACE = "Replace";
    public static final String ACTION_AT_CARET = "At caret position";
    public static final String ACTION_INSERT_BEFORE = "Before";
    public static final String ACTION_INSERT_AFTER = "After";
    public static final String ACTION_INSERT_AS_FIRST_CHILD = "Inside as first child";
    public static final String ACTION_INSERT_AS_LAST_CHILD = "Inside as last child";
    public static final String CARET_POSITION_PRESERVE = "Preserve";
    public static final String CARET_POSITION_BEFORE = "Before";
    public static final String CARET_POSITION_START = "Start";
    public static final String CARET_POSITION_EDITABLE = "First editable position";
    public static final String CARET_POSITION_END = "End";
    public static final String CARET_POSITION_AFTER = "After";
    private static final String ARGUMENT_XPATH_SOURCE = "sourceLocation";
    private static final String ARGUMENT_XPATH_TARGET = "targetLocation";
    protected String ARGUMENT_SCRIPT = "script";
    private static final String ARGUMENT_ACTION = "action";
    private static final String ARGUMENT_CARET_POSITION = "caretPosition";
    private static final String ARGUMENT_EXPAND_EDITOR_VARIABLES = "expandEditorVariables";
    private static final String ARGUMENT_SUSPEND_TRACK_CHANGES = "suspendTrackChanges";
    private static final String ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING = "alwaysPreserveTrackedChangesBeforeProcessing";
    private static final String ARGUMENT_ESCAPE_ENTITY_REFS = "escapeEntityRefs";
    public static final String ARGUMENT_SCRIPT_PARAMETERS = "externalParams";
    private static final Splitter SPLITTER_ON_COMMA_OR_END_LINE = Splitter.on((Pattern)Pattern.compile("[,\n]")).trimResults().omitEmptyStrings();
    private static final Splitter SPLITTER_ON_EQUALS = Splitter.on((String)"=").trimResults().omitEmptyStrings();
    private Map externalArguments = null;
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[10];

    public TransformOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_SOURCE, 2, "An XPath expression indicating the element that the script will be applied on.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_TARGET, 2, "An XPath expression indicating the insert location for the result of the transformation.\nNote: If it is not defined then the insert location will be at the caret.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(this.ARGUMENT_SCRIPT, 4, "A path to the script or the script itself.\nWhen using a path the following apply:\n- a relative path is resolved to the framework directory. \n- the ${framework} editor variable can also be used to refer resources from the framework directory. \n- the path is passed through the catalog mappings.\nIf you provide the actual script, the base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ACTION, 3, "The insert action relative to the node determined by the target XPath expression.\nIt can be: Replace, At caret position, Before, After, Inside as first child or Inside as last child.\n", new String[]{ACTION_REPLACE, ACTION_AT_CARET, "Before", "After", ACTION_INSERT_AS_FIRST_CHILD, ACTION_INSERT_AS_LAST_CHILD}, ACTION_REPLACE);
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_CARET_POSITION, 3, "The position of the caret after the action is executed.\nIt can be: Preserve, Before, Start, First editable position, End or After.\n", new String[]{CARET_POSITION_PRESERVE, "Before", CARET_POSITION_START, CARET_POSITION_EDITABLE, CARET_POSITION_END, "After"}, CARET_POSITION_EDITABLE);
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_EDITOR_VARIABLES, 3, "Parameter controlling the expansion of editor variables returned by the script processing.\nExpansion is enabled by default.", new String[]{"true", "false"}, "true");
        this.arguments[6] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SUSPEND_TRACK_CHANGES, 0, "Disable Track Changes during the operation's execution.\nBy default the state of track changes is not altered.", new String[]{"true", "false"}, "false");
        this.arguments[7] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT_PARAMETERS, 0, "Provide external parameters to the script.\nShould be inserted as name=value pairs separated by comma or line break.");
        this.arguments[8] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING, 0, "Always preserve tracked changes before processing, regardless of the track changes state.", new String[]{"true", "false"}, "false");
        this.arguments[9] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ESCAPE_ENTITY_REFS, 0, "Escape entity references in processed content to plain text and unescape them back in the returned content.", new String[]{"true", "false"}, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        int n2;
        int n3;
        Object object;
        int n4;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        AuthorNode authorNode;
        AuthorElement authorElement;
        AuthorNode[] authorNodeArray;
        Object object7 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_SOURCE);
        Object object8 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_TARGET);
        Object object9 = argumentsMap.getArgumentValue(this.ARGUMENT_SCRIPT);
        Object object10 = argumentsMap.getArgumentValue(ARGUMENT_ACTION);
        Object object11 = argumentsMap.getArgumentValue(ARGUMENT_CARET_POSITION);
        Object object12 = argumentsMap.getArgumentValue(ARGUMENT_SUSPEND_TRACK_CHANGES);
        Object object13 = argumentsMap.getArgumentValue(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING);
        Object object14 = argumentsMap.getArgumentValue(ARGUMENT_ESCAPE_ENTITY_REFS);
        boolean bl = object14 == null || "true".equalsIgnoreCase(object14.toString());
        Object object15 = argumentsMap.getArgumentValue(ARGUMENT_SCRIPT_PARAMETERS);
        if (!(object9 instanceof String)) {
            throw new IllegalArgumentException("The argument \"script\" was not defined as a string object!");
        }
        String string2 = (String)object9;
        AuthorNode authorNode2 = null;
        AuthorElement authorElement2 = null;
        AuthorNode authorNode3 = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("Cannot identify the current node", badLocationException);
        }
        authorNode2 = authorNode3;
        for (authorNode3 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode3 != null && !(authorNode3 instanceof AuthorElement); authorNode3 = authorNode3.getParent()) {
        }
        authorElement2 = authorNode3 instanceof AuthorElement ? (AuthorElement)authorNode3 : authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (object7 instanceof String && !"".equals(object7)) {
            authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object7, true, true, false);
            if (authorNodeArray.length <= 0 || !(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The source XPath location does not identify an element: " + object7);
            authorElement = (AuthorElement)authorNodeArray[0];
        } else {
            authorElement = authorElement2;
        }
        authorNodeArray = ElementLocationPath.getCurrentElementLocation(authorAccess.getReviewController(), authorElement2, authorElement);
        String string3 = authorNodeArray.toXPath();
        if (object8 instanceof String && !"".equals(object8)) {
            AuthorNode[] authorNodeArray2 = authorAccess.getDocumentController().findNodesByXPath((String)object8, true, true, false);
            if (authorNodeArray2.length <= 0) throw new AuthorOperationException("The target XPath location does not identify a node: " + object8);
            authorNode = authorNodeArray2[0];
        } else {
            authorNode = authorNode2;
        }
        Object var21_22 = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean bl2 = object13 != null && "true".equalsIgnoreCase(object13.toString());
            object6 = bl2 ? authorAccess.getDocumentController().createDocumentFragment(authorElement.getStartOffset(), authorElement.getEndOffset(), true) : authorAccess.getDocumentController().createDocumentFragment(authorElement, true);
            string = authorAccess.getDocumentController().serializeFragmentToXML((AuthorDocumentFragment)object6);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
            throw new AuthorOperationException("Could not serialize source", badLocationException);
        }
        if (string == null) {
            throw new AuthorOperationException("Cannot serialize the source element: " + object7);
        }
        AuthorDocumentType authorDocumentType = authorAccess.getDocumentController().getDoctype();
        if (authorDocumentType != null && (object6 = authorDocumentType.serializeDoctype()) != null) {
            stringBuilder.append((String)object6);
        }
        object6 = authorAccess.getDocumentController().getAuthorDocumentNode().getContentNodes();
        for (int i2 = 0; i2 < object6.size() && (object5 = object6.get(i2)).getType() != 0; ++i2) {
            if (object5.getType() != 5) continue;
            try {
                object4 = object5.getTextContent();
                if (object4 == null || !((String)object4).startsWith("xml-model") && !((String)object4).startsWith("oxygen")) continue;
                stringBuilder.append("<?").append((String)object4).append("?>\n");
                continue;
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        stringBuilder.append(string);
        InputSource inputSource = null;
        object5 = CommonsOperationsUtil.expandAndResolvePath(authorAccess, string2);
        if (object5 != null) {
            inputSource = new InputSource(((URL)object5).toExternalForm());
        } else {
            if (!this.canTreatAsScript(string2)) throw new AuthorOperationException("Could not find a location on disk corresponding to the 'script' parameter value: " + string2);
            inputSource = new InputSource(new StringReader(string2));
            object4 = authorAccess.getUtilAccess().expandEditorVariables("${framework}", authorAccess.getEditorAccess().getEditorLocation());
            if (object4 != null && ((String)object4).contains("${framework}")) {
                object4 = authorAccess.getEditorAccess().getEditorLocation().toString();
            }
            inputSource.setSystemId((String)object4);
        }
        if (object15 instanceof String && !((String)object15).trim().equals("")) {
            try {
                this.externalArguments = SPLITTER_ON_COMMA_OR_END_LINE.withKeyValueSeparator(SPLITTER_ON_EQUALS).split((CharSequence)String.valueOf(object15));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AuthorOperationException(illegalArgumentException.getMessage());
            }
        }
        object4 = new SAXSource(inputSource);
        Transformer transformer = null;
        try {
            transformer = this.createTransformer(authorAccess, (Source)object4, (ElementLocationPath)authorNodeArray);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            logger.debug((Object)transformerConfigurationException, (Throwable)transformerConfigurationException);
            throw new AuthorOperationException("Cannot create a transformer from the provided script:\n" + string2 + "\nReason:" + transformerConfigurationException.getMessage());
        }
        if (transformer == null) return;
        transformer.setOutputProperty("indent", "no");
        transformer.setParameter(CURRENT_ELEMENT_LOCATION, string3);
        if (this.externalArguments != null) {
            object3 = this.externalArguments.keySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                transformer.setParameter((String)object2, this.externalArguments.get(object2));
            }
        }
        object2 = object3 = new StringWriter();
        if (bl) {
            object2 = new UnescapeWriter((Writer)object2);
        }
        InputSource inputSource2 = null;
        inputSource2 = bl ? new InputSource((Reader)new EscapingReader((Reader)new StringReader(stringBuilder.toString()))) : new InputSource(new StringReader(stringBuilder.toString()));
        inputSource2.setSystemId(authorElement.getXMLBaseURL().toString());
        SAXSource sAXSource = new SAXSource(inputSource2);
        try {
            transformer.transform(sAXSource, new StreamResult((Writer)object2));
        }
        catch (TransformerException transformerException) {
            logger.debug((Object)transformerException, (Throwable)transformerException);
            throw new AuthorOperationException("The script cannot be executed: " + transformerException.getMessageAndLocation());
        }
        finally {
            try {
                ((Writer)object2).close();
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
        boolean bl3 = argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES) == null || "true".equals(argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES));
        boolean bl4 = false;
        Object object16 = ((StringWriter)object3).toString();
        if (((String)object16).startsWith("<?xml ") && (n4 = ((String)object16).indexOf("?>")) != -1) {
            object16 = ((String)object16).substring(n4 + 2);
        }
        if (bl3) {
            n4 = ((String)object16).indexOf("${selection}");
            if (n4 != -1) {
                String string4 = "";
                try {
                    if (authorAccess.getEditorAccess().hasSelection()) {
                        object = authorAccess.getDocumentController().createDocumentFragment(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
                        string4 = authorAccess.getDocumentController().serializeFragmentToXML((AuthorDocumentFragment)object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
                object16 = ((String)object16).substring(0, n4) + string4 + ((String)object16).substring(n4 + "${selection}".length(), ((String)object16).length());
            }
            if ((n3 = ((String)(object16 = authorAccess.getUtilAccess().expandEditorVariables((String)object16, authorAccess.getEditorAccess().getEditorLocation()))).indexOf("${caret}")) != -1) {
                object16 = ((String)object16).substring(0, n3) + "<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>" + ((String)object16).substring(n3 + "${caret}".length(), ((String)object16).length());
                bl4 = true;
            }
        }
        n4 = authorAccess.getEditorAccess().getCaretOffset();
        n3 = authorAccess.getEditorAccess().getCaretOffset();
        if (ACTION_REPLACE.equals(object10)) {
            n3 = authorNode.getStartOffset();
        } else if (!ACTION_AT_CARET.equals(object10)) {
            object = object8 != null && ((String)object8).trim().length() > 0 ? (String)object8 : ".";
            n3 = authorAccess.getDocumentController().getXPathLocationOffset((String)object, (String)object10);
        }
        object = null;
        try {
            object = authorAccess.getDocumentController().createPositionInContent(n3);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        boolean bl5 = false;
        if (authorAccess.getReviewController().isTrackingChanges() && Boolean.valueOf(object12.toString()).booleanValue()) {
            authorAccess.getReviewController().toggleTrackChanges();
            bl5 = true;
        }
        try {
            if (ACTION_REPLACE.equals(object10)) {
                if (authorNode.getType() == 2) {
                    authorNode = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
                }
                if (authorNode.getParent().getType() == 2) {
                    AuthorDocumentFragment authorDocumentFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext((String)object16, authorNode.getStartOffset());
                    authorAccess.getDocumentController().replaceRoot(authorDocumentFragment);
                } else {
                    authorAccess.getDocumentController().insertXMLFragment((String)object16, authorNode, "Before");
                    authorAccess.getDocumentController().deleteNode(authorNode);
                }
            } else if (ACTION_AT_CARET.equals(object10)) {
                authorAccess.getDocumentController().insertXMLFragment((String)object16, authorAccess.getEditorAccess().getCaretOffset());
            } else {
                authorAccess.getDocumentController().insertXMLFragment((String)object16, authorNode, (String)object10);
            }
        }
        finally {
            if (bl5) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
        int n5 = n3 + 1;
        int n6 = n2 = object != null ? object.getOffset() - 1 : n5;
        if (n4 < n5) {
            n4 = n5;
        }
        if (n4 > n2) {
            n4 = n2;
        }
        if (bl4) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n3);
            return;
        }
        if ("Before".equals(object11)) {
            authorAccess.getEditorAccess().setCaretPosition(n5 - 1);
            return;
        }
        if (CARET_POSITION_START.equals(object11)) {
            authorAccess.getEditorAccess().setCaretPosition(n5);
            return;
        }
        if (CARET_POSITION_PRESERVE.equals(object11)) {
            authorAccess.getEditorAccess().setCaretPosition(n4);
            return;
        }
        if (CARET_POSITION_END.equals(object11)) {
            authorAccess.getEditorAccess().setCaretPosition(n2);
            return;
        }
        if ("After".equals(object11)) {
            authorAccess.getEditorAccess().setCaretPosition(n2 + 1);
            return;
        }
        try {
            authorAccess.getEditorAccess().goToNextEditablePosition(n5 - 1, n2);
            return;
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
    }

    protected boolean canTreatAsScript(String string) {
        return true;
    }

    protected abstract Transformer createTransformer(AuthorAccess var1, Source var2) throws TransformerConfigurationException;

    protected Transformer createTransformer(AuthorAccess authorAccess, Source source, ElementLocationPath elementLocationPath) throws TransformerConfigurationException {
        return this.createTransformer(authorAccess, source);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Run a script on a source element and then replace or insert the result in a target node.";
    }
}

