/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class PromoteDemoteItemOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)PromoteDemoteItemOperation.class.getName());
    private static final String ARGUMENT_PROMOTE = "promote";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("promote", 3, "Should be true to promote the list item at the caret position, or false to demote it.", new String[]{"true", "false"}, "false")};

    @Override
    public String getDescription() {
        return "Promotes or demotes a list item.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorActionEventHandler authorActionEventHandler = CommonAccess.getAuthorActionEventHandler(authorAccess);
        if (authorActionEventHandler != null) {
            boolean bl = "true".equals(argumentsMap.getArgumentValue(ARGUMENT_PROMOTE));
            AuthorActionEventHandler.AuthorActionEventType authorActionEventType = bl ? AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB : AuthorActionEventHandler.AuthorActionEventType.TAB;
            boolean bl2 = authorActionEventHandler.canHandleEvent(authorAccess, authorActionEventType);
            if (bl2) {
                authorActionEventHandler.handleEvent(authorAccess, authorActionEventType);
            }
        } else {
            logger.debug("No event handler set for the current framework.");
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }
}

