/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class OpenInSystemAppOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)OpenInSystemAppOperation.class.getName());
    static final String ARGUMENT_RESOURCE_PATH = "resourcePath";
    private static final String ARGUMENT_UNPARSED_ENTITY = "isUnparsedEntity";
    private static final String ARGUMENT_MEDIA_TYPE = "mediaType";
    public static final String MEDIA_TYPE_VIDEO = "video";
    public static final String MEDIA_TYPE_AUDIO = "audio";
    public static final String MEDIA_TYPE_MEDIA = "media";
    public static final String MEDIA_TYPE_IMAGE = "image";
    public static final String MEDIA_TYPE_HTML = "html";
    public static final String MEDIA_TYPE_PDF = "pdf";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];

    public OpenInSystemAppOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RESOURCE_PATH, 2, "An XPath expression that gives the path of the resource that must be opened.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_UNPARSED_ENTITY, 3, "True if the value returned by the resourcePath argument represents the name of an unparsed entity.", new String[]{"true", "false"}, "false");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_MEDIA_TYPE, 3, "The media type of the file to be opened. ", new String[]{MEDIA_TYPE_VIDEO, MEDIA_TYPE_AUDIO, MEDIA_TYPE_MEDIA, MEDIA_TYPE_IMAGE, MEDIA_TYPE_HTML, MEDIA_TYPE_PDF}, MEDIA_TYPE_HTML);
    }

    @Override
    public String getDescription() {
        return "Open in default system application";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_RESOURCE_PATH);
        if (object != null && ((String)object).trim().length() > 0) {
            object = authorAccess.getUtilAccess().expandEditorVariables((String)object, authorAccess.getEditorAccess().getEditorLocation());
            Object[] objectArray = authorAccess.getDocumentController().evaluateXPath((String)object, null, false, true, true, false, XPathVersion.XPATH_3_0);
            if (objectArray != null && objectArray.length > 0) {
                String string = null;
                if (objectArray[0] instanceof String) {
                    string = (String)objectArray[0];
                } else if (objectArray[0] instanceof Node) {
                    string = ((Node)objectArray[0]).getNodeValue();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Relative location " + string);
                }
                if (string != null) {
                    OpenInSystemAppOperation.open(string, authorAccess, argumentsMap);
                }
            } else {
                throw new AuthorOperationException("The resource path XPath must evaluate to a string or node: " + object);
            }
        }
    }

    private static void open(String string, AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        String string2;
        Object object;
        URL uRL = null;
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        AuthorNode authorNode = null;
        if (n2 > 0) {
            try {
                authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        if (authorNode == null) {
            authorNode = authorAccess.getDocumentController().getAuthorDocumentNode();
        }
        if ("true".equals(object = argumentsMap.getArgumentValue(ARGUMENT_UNPARSED_ENTITY))) {
            string2 = authorAccess.getDocumentController().getUnparsedEntityUri(authorNode, string);
            if (string2 != null) {
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                }
            }
        } else {
            uRL = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(authorNode != null ? authorNode.getXMLBaseURL() : authorAccess.getEditorAccess().getEditorLocation(), string, true, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Absolute location to open: " + URLUtil.filterPasswords((String)String.valueOf(uRL)));
        }
        string2 = (String)argumentsMap.getArgumentValue(ARGUMENT_MEDIA_TYPE);
        if (uRL != null) {
            File file = authorAccess.getUtilAccess().locateFile(uRL);
            if (file != null && !file.exists()) {
                throw new AuthorOperationException("Resource does not exists: " + uRL);
            }
            authorAccess.getWorkspaceAccess().openInExternalApplication(uRL, true, string2);
        } else {
            String string3;
            String string4 = string;
            if ("true".equals(object) && (string3 = authorAccess.getDocumentController().getUnparsedEntityUri(authorNode, string)) != null) {
                string4 = string3;
            }
            authorAccess.getWorkspaceAccess().openInExternalApplication(string4, true, string2);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

