/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class MoveCaretOperation
implements AuthorOperation {
    private static final String XPATH_LOCATION = "xpathLocation";
    private static final String POSITION = "position";
    private static final String SELECTION = "selection";
    private static final ArgumentDescriptor XPATH_LOCATION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("xpathLocation", 2, "An XPath expression identifying the node relative to which the caret will be moved. If the expression identifies more than one node, only the first one will be taken into account.", ".");
    private static final ArgumentDescriptor POSITION_DESCRIPTOR = new ArgumentDescriptor("position", 3, "The position relative to the node obtained from the XPath expression where the caret will be moved. When also choosing to perform a selection, \"Before\" and \"Inside, at the beginning\" will both place the caret at the beginning of the selection. In the same way, \"After\" and \"Inside, at the end\" will place the caret at the end of the selection.", new String[]{"Before", "After", "Inside, at the beginning", "Inside, at the end"}, "Inside, at the beginning");
    private static final ArgumentDescriptor SELECTION_DESCRIPTOR = new ArgumentDescriptor("selection", 3, "This argument specifies if the operation should select the node obtained from the XPath expression, its content or nothing at all.", new String[]{"None", "Content", "Element"}, "None");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{XPATH_LOCATION_ARGUMENT_DESCRIPTOR, POSITION_DESCRIPTOR, SELECTION_DESCRIPTOR};

    @Override
    public String getDescription() {
        return "Author operation capable of moving the caret relative to an XML node identified by an XPath expression. The operation can also select an XML element or its content.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        String string = (String)argumentsMap.getArgumentValue(XPATH_LOCATION);
        String string2 = (String)argumentsMap.getArgumentValue(POSITION);
        String string3 = (String)argumentsMap.getArgumentValue(SELECTION);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorNode[] authorNodeArray = authorDocumentController.findNodesByXPath(string, true, true, false);
        if (authorNodeArray.length != 0) {
            AuthorNode authorNode = authorNodeArray[0];
            if (string3.equals("None")) {
                if (string2.equals("Before")) {
                    authorAccess.getEditorAccess().setCaretPosition(authorNode.getStartOffset());
                } else if (string2.equals("After")) {
                    authorAccess.getEditorAccess().setCaretPosition(authorNode.getEndOffset() + 1);
                } else if (string2.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().setCaretPosition(authorNode.getStartOffset() + 1);
                } else if (string2.equals("Inside, at the end")) {
                    authorAccess.getEditorAccess().setCaretPosition(authorNode.getEndOffset());
                }
            } else if (string3.equals("Content")) {
                if (string2.equals("Before") || string2.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().select(authorNode.getEndOffset(), authorNode.getStartOffset() + 1);
                } else {
                    authorAccess.getEditorAccess().select(authorNode.getStartOffset() + 1, authorNode.getEndOffset());
                }
            } else if (string3.equals("Element")) {
                if (string2.equals("Before") || string2.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().select(authorNode.getEndOffset() + 1, authorNode.getStartOffset());
                } else {
                    authorAccess.getEditorAccess().select(authorNode.getStartOffset(), authorNode.getEndOffset() + 1);
                }
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

