/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.InsertFragmentOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertOrReplaceFragmentOperation
extends InsertFragmentOperation {
    static final String POSITION_REPLACE = "Replace";
    private static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child, Replace or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After", "Replace"}, "Inside as first child");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{ARGUMENT_DESCRIPTOR_FRAGMENT, ARGUMENT_DESCRIPTOR_XPATH_LOCATION, ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION, SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        authorDocumentController.beginCompoundEdit();
        boolean bl = false;
        try {
            AuthorNode[] authorNodeArray;
            Object object;
            if (authorAccess.getEditorAccess().hasSelection()) {
                bl = true;
                authorAccess.getEditorAccess().deleteSelection();
            }
            Object object2 = argumentsMap.getArgumentValue("insertLocation");
            Object object3 = argumentsMap.getArgumentValue("insertPosition");
            if (POSITION_REPLACE.equals(object3)) {
                if (object2 instanceof String && ((String)(object = (String)object2)).trim().length() > 0 && (authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object, true, true, true)) != null && authorNodeArray.length > 0) {
                    authorAccess.getEditorAccess().select(authorNodeArray[0].getStartOffset(), authorNodeArray[0].getEndOffset() + 1);
                    authorAccess.getEditorAccess().deleteSelection();
                }
                object2 = null;
            }
            object = argumentsMap.getArgumentValue("fragment");
            authorNodeArray = argumentsMap.getArgumentValue("goToNextEditablePosition");
            if (authorNodeArray == null) {
                authorNodeArray = "true";
            }
            boolean bl2 = "true".equals(authorNodeArray);
            Object object4 = argumentsMap.getArgumentValue("schemaAware");
            Object object5 = argumentsMap.getArgumentValue("insertEvenIfInvalid");
            if (object5 == null) {
                object5 = "true";
            }
            boolean bl3 = "true".equals(object5);
            this.doOperationInternal(authorAccess, object, object2, object3, bl2, object4, bl3);
        }
        catch (AuthorOperationException authorOperationException) {
            if (bl) {
                authorDocumentController.cancelCompoundEdit();
            }
            throw authorOperationException;
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    @Override
    public String getDescription() {
        return "Insert a document fragment. If selection is present, the selection will be replaced with the given fragment.";
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

