/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorWorkspaceAccess;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.exml.workspace.api.images.handlers.CannotEditException;
import ro.sync.exml.workspace.api.images.handlers.EditImageHandler;
import ro.sync.exml.workspace.api.images.handlers.ImageHandler;
import ro.sync.exml.workspace.api.images.handlers.providers.EmbeddedImageContentProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertEquationOperation
implements AuthorOperation {
    private static final String ARGUMENT_FRAGMENT_WITH_MATHML = "fragment";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    public static final String MATH_ML_NAMESPACE = "\"http://www.w3.org/1998/Math/MathML\"";
    public static final String MATH_ML = "<mml:math xmlns:mml=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">" + "</mml:math>";
    public static final String MATH_ML_FOR_HTML_DOC_TYPE = "<math xmlns=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">\n" + "</math>";
    public static final String WEBAPP_MATH_ML = "<m:math xmlns:m=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">" + "<m:mrow>" + "<m:msup><m:mi>a</m:mi><m:mn>2</m:mn></m:msup>" + "<m:mo>=</m:mo>" + "<m:msup><m:mi>b</m:mi><m:mn>2</m:mn></m:msup>" + "<m:mo>+</m:mo>" + "<m:msup><m:mi>c</m:mi><m:mn>2</m:mn>" + "</m:msup></m:mrow>" + "</m:math>";

    public InsertEquationOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_FRAGMENT_WITH_MATHML, 1, "The fragment of XML containing the default MathML content which should be inserted");
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        try {
            boolean bl;
            AuthorWorkspaceAccess authorWorkspaceAccess = authorAccess.getWorkspaceAccess();
            ImageHandler imageHandler = null;
            if (authorWorkspaceAccess.getPlatform() == Platform.WEBAPP) {
                bl = true;
            } else {
                imageHandler = authorWorkspaceAccess.getImageUtilities().getImageHandlerFor("mathml");
                bl = imageHandler instanceof EditImageHandler;
            }
            if (bl) {
                String string = null;
                AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                AuthorDocumentType authorDocumentType = authorDocumentController.getDoctype();
                if (authorDocumentType != null) {
                    string = authorDocumentType.getContent();
                }
                AuthorSchemaManager authorSchemaManager = authorDocumentController.getAuthorSchemaManager();
                String string2 = this.createDefaultFragmentToEdit(authorAccess, authorSchemaManager);
                Object object = argumentsMap.getArgumentValue(ARGUMENT_FRAGMENT_WITH_MATHML);
                if (object instanceof String && !((String)object).isEmpty()) {
                    string2 = (String)object;
                }
                String string3 = InsertEquationOperation.extractMathMLFragment(string2);
                String string4 = null;
                if (string3 != null) {
                    EmbeddedImageContentProvider embeddedImageContentProvider = new EmbeddedImageContentProvider(authorAccess.getEditorAccess().getEditorLocation(), string3, string);
                    string4 = InsertEquationOperation.editImage(imageHandler, embeddedImageContentProvider);
                }
                if (string4 != null) {
                    string2 = string2.replace(string3, string4);
                }
                if (string4 != null || string3 == null) {
                    int n2 = authorAccess.getEditorAccess().getCaretOffset();
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string2, n2);
                }
            } else {
                authorWorkspaceAccess.showInformationMessage("MathML editing is not supported.");
            }
        }
        catch (CannotEditException cannotEditException) {
            throw new AuthorOperationException(cannotEditException.getMessage(), cannotEditException);
        }
    }

    private static String editImage(ImageHandler imageHandler, EmbeddedImageContentProvider embeddedImageContentProvider) throws CannotEditException {
        if (imageHandler instanceof EditImageHandler) {
            return ((EditImageHandler)imageHandler).editImage(embeddedImageContentProvider);
        }
        String string = WEBAPP_MATH_ML;
        String string2 = embeddedImageContentProvider.getImageSerializedContent();
        if (string2.contains("mml:")) {
            string = string.replace("<m:", "<mml:");
            string = string.replace("</m:", "</mml:");
            string = string.replace("xmlns:m", "xmlns:mml");
        }
        return string;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Insert a MathML equation.";
    }

    protected String createDefaultFragmentToEdit(AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) {
        return MATH_ML;
    }

    private static String extractMathMLFragment(String string) {
        String string2;
        int n2;
        String string3 = null;
        int n3 = string.indexOf(MATH_ML_NAMESPACE.substring(1, MATH_ML_NAMESPACE.length() - 1));
        if (n3 != -1 && (n2 = (string2 = string.substring(0, n3)).lastIndexOf(60)) != -1) {
            String string4;
            String string5;
            int n4;
            String string6 = null;
            for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                char c2 = string.charAt(i2);
                if (!Character.isWhitespace(c2)) continue;
                string6 = string.substring(n2 + 1, i2);
                break;
            }
            if (string6 != null && (n4 = (string5 = string.substring(n3, string.length())).indexOf(string4 = "</" + string6 + ">")) != -1) {
                string3 = string.substring(n2, n3 + n4 + string4.length());
            }
        }
        return string3;
    }
}

