/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.exml.workspace.api.process.ProcessController;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteCommandLineOperation
implements AuthorOperation {
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static final String NAME = "name";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private static final String CMD_LINE = "cmdLine";
    private static final String SHOW_CONSOLE = "showConsole";
    private static final String WAIT = "wait";
    private static final ArgumentDescriptor NAME_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("name", 0, "The name of the operation. It will also be used as the name of the console.", "Command Line Operation");
    private static final ArgumentDescriptor WORKING_DIRECTORY_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("workingDirectory", 0, "The path to the working directory where the command line will be executed.", ".");
    private static final ArgumentDescriptor CMD_LINE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("cmdLine", 0, "The command line to be executed. It can contain oXygen editor variables. IMPORTANT: This operation is meant for executing programs. Not any string that a command line interpreter (or shell) accepts can be run by this operation.For example, the \"dir\" command line from Windows is not accepted as it is. The accepted form is \"cmd /c dir\".");
    private static final ArgumentDescriptor SHOW_CONSOLE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("showConsole", 3, "True to show the console when running the command line.", new String[]{"true", "false"}, "false");
    private static final ArgumentDescriptor WAIT_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("wait", 3, "True to wait until the command terminates to return.", new String[]{"true", "false"}, "false");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAME_ARGUMENT_DESCRIPTOR, WORKING_DIRECTORY_ARGUMENT_DESCRIPTOR, CMD_LINE_ARGUMENT_DESCRIPTOR, SHOW_CONSOLE_ARGUMENT_DESCRIPTOR, WAIT_ARGUMENT_DESCRIPTOR};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        String string = (String)argumentsMap.getArgumentValue(NAME);
        File file = new File((String)argumentsMap.getArgumentValue(WORKING_DIRECTORY));
        String string2 = (String)argumentsMap.getArgumentValue(CMD_LINE);
        boolean bl = TRUE_STRING.equals(argumentsMap.getArgumentValue(SHOW_CONSOLE));
        boolean bl2 = TRUE_STRING.equals(argumentsMap.getArgumentValue(WAIT));
        if (bl2) {
            ProcessController processController = authorAccess.getWorkspaceAccess().createProcess(null, string, file, string2, bl);
            processController.start();
        } else {
            authorAccess.getWorkspaceAccess().startProcess(string, file, string2, bl);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Author operation allowing the execution of command lines.";
    }
}

