/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangePseudoClassesOperation
implements AuthorOperation {
    private static final String ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS = "setLocations";
    private static final String ARGUMENT_SET_PSEUDOCLASS_NAMES = "setPseudoClassNames";
    private static final String ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS = "removeLocations";
    private static final String ARGUMENT_REMOVE_PSEUDOCLASS_NAMES = "removePseudoClassNames";
    private static final String ARGUMENT_INCLUDE_ALL_NODES = "includeAllNodes";
    private static final String YES = "yes";
    private static final String NO = "no";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[5];

    public ChangePseudoClassesOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes on which the specified list of pseudo classes will be set.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SET_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be set on the matched nodes.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes from which the specified list of pseudo classes will be removed.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be removed from the matched nodes.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_INCLUDE_ALL_NODES, 3, "The value should be \"yes\" in order to include comments, text and CDATA nodes in the XPath execution, \"no\" to ignore them.", new String[]{YES, NO}, NO);
    }

    @Override
    public String getDescription() {
        return "Sets a set of pseudo classes to all nodes identified by an XPath expression.\nRemoves a set of pseudo classes from all nodes identified by an XPath expression.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, argumentsMap, ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, ARGUMENT_SET_PSEUDOCLASS_NAMES, true);
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, argumentsMap, ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrRemovePseudoClasses(AuthorAccess authorAccess, ArgumentsMap argumentsMap, String string, String string2, boolean bl) throws AuthorOperationException {
        String[] stringArray;
        Object object = argumentsMap.getArgumentValue(string);
        Object object2 = argumentsMap.getArgumentValue(string2);
        Object object3 = argumentsMap.getArgumentValue(ARGUMENT_INCLUDE_ALL_NODES);
        if (object2 instanceof String && (stringArray = ((String)object2).split(" ")) != null && stringArray.length > 0) {
            List<AuthorElement> list = ChangePseudoClassesOperation.getTargetElements(authorAccess, object, object3);
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            authorDocumentController.disableLayoutUpdate();
            try {
                for (AuthorElement authorElement : list) {
                    for (String string3 : stringArray) {
                        if (bl) {
                            authorDocumentController.setPseudoClass(string3, authorElement);
                            continue;
                        }
                        authorDocumentController.removePseudoClass(string3, authorElement);
                    }
                }
            }
            finally {
                AuthorNode authorNode = authorDocumentController.getCommonAncestor(list.toArray(new AuthorNode[0]));
                authorDocumentController.enableLayoutUpdate(authorNode);
            }
        }
    }

    private static List<AuthorElement> getTargetElements(AuthorAccess authorAccess, Object object, Object object2) throws AuthorOperationException {
        ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        if (object instanceof String && ((String)object).trim().length() > 0) {
            if (object2 instanceof String) {
                boolean bl = !object2.equals(YES);
                AuthorNode[] authorNodeArray = authorDocumentController.findNodesByXPath((String)object, bl, bl, bl);
                for (int i2 = 0; i2 < authorNodeArray.length; ++i2) {
                    AuthorNode authorNode = authorNodeArray[i2];
                    if (authorNode.getType() != 0) continue;
                    arrayList.add((AuthorElement)authorNode);
                }
                if (arrayList.isEmpty()) {
                    throw new AuthorOperationException("The element XPath location does not identify an element: " + object);
                }
            }
        } else {
            AuthorNode authorNode = null;
            try {
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current element", badLocationException);
            }
            for (authorNode = authorDocumentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null && !(authorNode instanceof AuthorElement); authorNode = authorNode.getParent()) {
            }
            if (authorNode instanceof AuthorElement) {
                arrayList.add((AuthorElement)authorNode);
            } else {
                throw new AuthorOperationException("You need to have the carret inside an element.");
            }
        }
        return arrayList;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

