/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangeAttributesOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ChangeAttributesOperation.class.getName());
    static final String ARGUMENT_ATTRIBUTE_NAMES = "attributeNames";
    static final String ARGUMENT_ATTRIBUTE_VALUES = "values";
    static final String ARGUMENT_ELEMENTS_XPATH_LOCATIONS = "elementLocations";
    static final String ARGUMENT_REMOVE_IF_EMPTY_VALUE = "removeIfEmpty";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[4];

    public ChangeAttributesOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENTS_XPATH_LOCATIONS, 2, "An XPath expression indicating the elements whose attributes will be affected.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAMES, 0, "The names of the attributes to change/insert/remove, each on a new line. The provided values can be local names or Clark notations {attribute_namespace}attibute_name.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_VALUES, 0, "The attribute values, each on a new line. An empty value will remove the corresponding attribute if 'removeIfEmpty' is set to 'true' (it is by default).");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_IF_EMPTY_VALUE, 3, "'true' means the attribute should be removed if an empty value is provided. The default value is 'true'.", new String[]{"true", "false"}, "true");
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ATTRIBUTE_NAMES);
        Object object2 = argumentsMap.getArgumentValue(ARGUMENT_ATTRIBUTE_VALUES);
        Object object3 = argumentsMap.getArgumentValue(ARGUMENT_ELEMENTS_XPATH_LOCATIONS);
        if (object instanceof String && !((String)object).isEmpty()) {
            AuthorElement[] authorElementArray;
            Object object4;
            String string = ((String)object).trim();
            String[] stringArray = string.split("\n");
            String[] stringArray2 = new String[stringArray.length];
            String[] stringArray3 = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                object4 = stringArray[i2].trim();
                if (((String)object4).startsWith("{") && ((String)object4).contains("}")) {
                    if (((String)object4).indexOf(125) < ((String)object4).length() - 1) {
                        stringArray2[i2] = ((String)object4).substring(((String)object4).indexOf(125) + 1).trim();
                        stringArray3[i2] = ((String)object4).substring(((String)object4).indexOf(123) + 1, ((String)object4).indexOf(125)).trim();
                        continue;
                    }
                    throw new AuthorOperationException("Incorrect Clark notation. The attribute name must be specified after the namespace value '{" + ((String)object4).substring(((String)object4).indexOf(123) + 1, ((String)object4).indexOf(125)).trim() + "}'.");
                }
                stringArray2[i2] = ((String)object4).trim();
                stringArray3[i2] = "";
            }
            String[] stringArray4 = null;
            if (object2 instanceof String) {
                object4 = (String)object2;
                stringArray4 = ((String)object4).split("\n");
            }
            if ((object4 = argumentsMap.getArgumentValue(ARGUMENT_REMOVE_IF_EMPTY_VALUE)) == null) {
                object4 = "true";
            }
            for (AuthorElement authorElement : authorElementArray = ChangeAttributesOperation.detectTargetElements(authorAccess, object3)) {
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    CommonsOperationsUtil.setAttributeValue(authorDocumentController, authorElement, new QName(stringArray3[i3], stringArray2[i3], ""), stringArray4 != null && i3 < stringArray4.length ? stringArray4[i3].trim() : "", "true".equals(object4));
                }
            }
        } else {
            throw new IllegalArgumentException("The argument 'attributeNames' was not defined!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthorElement[] detectTargetElements(AuthorAccess authorAccess, Object object) throws AuthorOperationException {
        AuthorElement[] authorElementArray = null;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        if (!(object instanceof String)) return ChangeAttributesOperation.detectElementAtOffset(authorAccess);
        if (((String)object).isEmpty()) return ChangeAttributesOperation.detectElementAtOffset(authorAccess);
        List<AuthorNode> list = Arrays.asList(authorDocumentController.findNodesByXPath((String)object, true, true, true));
        if (list.isEmpty()) throw new AuthorOperationException("The element XPath location does not identify any elements: " + object);
        Iterator<AuthorNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            AuthorNode authorNode = iterator.next();
            if (authorNode instanceof AuthorElement) continue;
            iterator.remove();
            logger.warn("The current node is not an element. It won't be taken into account. Node: " + authorNode);
        }
        return list.toArray(new AuthorElement[list.size()]);
    }

    private static AuthorElement[] detectElementAtOffset(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("Cannot identify the current element.", badLocationException);
        }
        for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null && !(authorNode instanceof AuthorElement); authorNode = authorNode.getParent()) {
        }
        AuthorElement[] authorElementArray = null;
        if (!(authorNode instanceof AuthorElement)) {
            throw new AuthorOperationException("You need to have the caret inside an element.");
        }
        authorElementArray = new AuthorElement[]{(AuthorElement)authorNode};
        return authorElementArray;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Add/change/remove one or more attributes for one or more elements.";
    }
}

