/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap;

import java.util.HashMap;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.commons.imagemap.EditImageMapCore;
import ro.sync.ecss.imagemap.IImageMapWrapper;
import ro.sync.ecss.imagemap.ImageMapAccess;
import ro.sync.ecss.imagemap.ImageMapFactory;
import ro.sync.ecss.imagemap.ImageMapUtil;
import ro.sync.ecss.imagemap.SupportedFrameworks;
import ro.sync.exml.view.graphics.Graphics;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorImageMapDecorator
extends AuthorImageDecorator {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorImageMapDecorator.class.getName());
    private EditImageMapCore imageMapCore;

    public AuthorImageMapDecorator(EditImageMapCore editImageMapCore) {
        this.imageMapCore = editImageMapCore;
    }

    protected abstract boolean isNodeOfInterest(AuthorNode var1, SupportedFrameworks var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, int n2, int n3, int n4, int n5, Rectangle rectangle, AuthorNode authorNode, AuthorAccess authorAccess, boolean bl) {
        String string = System.getProperty(TransformerFactory.class.getName());
        System.setProperty(TransformerFactory.class.getName(), TransformerFactoryImpl.class.getName());
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        try {
            AuthorNode[] authorNodeArray = this.imageMapCore.getNodesOfInterest(authorAccess, authorNode, false);
            if (authorNodeArray != null) {
                Rectangle rectangle2;
                int n6;
                SupportedFrameworks supportedFrameworks = this.imageMapCore.getSupportedFramework(authorNodeArray[0].getNamespace());
                if (!this.isNodeOfInterest(authorNode, supportedFrameworks)) {
                    return;
                }
                AuthorDocumentFragment[] authorDocumentFragmentArray = new AuthorDocumentFragment[authorNodeArray.length];
                String[] stringArray = new String[authorNodeArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    authorDocumentFragmentArray[i2] = authorDocumentController.createDocumentFragment(authorNodeArray[i2], true);
                    stringArray[i2] = authorDocumentController.serializeFragmentToXML(authorDocumentFragmentArray[i2]);
                }
                NamespaceContext namespaceContext = authorNodeArray[0].getNamespaceContext();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String[] stringArray2 = namespaceContext.getNamespaces();
                for (n6 = 0; n6 < stringArray2.length; ++n6) {
                    hashMap.put(stringArray2[n6], namespaceContext.getPrefixForNamespace(stringArray2[n6]));
                }
                n6 = ImageMapUtil.getFontOfNodeSize(authorAccess, authorNodeArray[0]);
                IImageMapWrapper iImageMapWrapper = ImageMapFactory.getInstance().getImageMap(supportedFrameworks, authorAccess, n6, authorAccess.getEditorAccess().getEditorLocation(), hashMap, stringArray);
                Rectangle rectangle3 = new Rectangle(0, 0, n4, n5);
                Rectangle rectangle4 = iImageMapWrapper.getImposedImageSize(rectangle3);
                double d2 = 1.0;
                Rectangle rectangle5 = rectangle2 = rectangle4 == null ? rectangle3 : rectangle4;
                if (!rectangle3.equals(rectangle4) && rectangle != null && !rectangle.equals(rectangle2)) {
                    d2 = (double)rectangle2.width / (double)rectangle.width;
                }
                ImageMapAccess.getInstance().paintImageMapAreas(graphics, n2, n3, rectangle2.width, rectangle2.height, d2, authorAccess, iImageMapWrapper, supportedFrameworks, n6, bl);
            }
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)throwable, throwable);
            }
        }
        finally {
            if (string == null) {
                System.clearProperty(TransformerFactory.class.getName());
            } else {
                System.setProperty(TransformerFactory.class.getName(), string);
            }
        }
    }
}

